/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.shindig.gadgets.js;

import com.google.inject.ImplementedBy;

/**
 * A pipeline to process Javascript requests.
 *
 * These requests go through several processing steps that may provide features
 * like compilation, cajoling, etc.
 */
@ImplementedBy(DefaultJsServingPipeline.class)
public interface JsServingPipeline {

  /**
   * Executes the steps in the pipeline and returns the resulting response.
   *
   * @param jsRequest The JS request.
   * @return The JavaScript response generated by the pipeline.
   * @throws JsException If any of the steps resulted in an error.
   */
  JsResponse execute(JsRequest jsRequest) throws JsException;
}
