/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.util.OpenSocialVersion;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.UriCommon;

public class Gadget {
    private FeatureRegistry featureRegistry;
    private GadgetContext context;
    private GadgetSpec spec;
    private Collection<PreloadedData> preloads;
    private View currentView;
    private Set<String> directFeatureDeps;
    private List<String> allGadgetFeatures;

    public Gadget setContext(GadgetContext context) {
        this.context = context;
        this.directFeatureDeps = null;
        this.allGadgetFeatures = null;
        return this;
    }

    public GadgetContext getContext() {
        return this.context;
    }

    public synchronized Gadget setGadgetFeatureRegistry(FeatureRegistry registry) {
        this.featureRegistry = registry;
        return this;
    }

    public Gadget setSpec(GadgetSpec spec) {
        this.spec = spec;
        return this;
    }

    public GadgetSpec getSpec() {
        return this.spec;
    }

    public OpenSocialVersion getSpecificationVersion() {
        if (this.spec != null) {
            return this.spec.getSpecificationVersion();
        }
        return null;
    }

    public boolean useQuirksMode() {
        if (this.spec != null) {
            return "quirksmode".equals(this.spec.getModulePrefs().getDoctype());
        }
        return false;
    }

    public Gadget setPreloads(Collection<PreloadedData> preloads) {
        this.preloads = preloads;
        return this;
    }

    public Collection<PreloadedData> getPreloads() {
        return this.preloads;
    }

    public synchronized List<String> getAllFeatures() {
        if (this.allGadgetFeatures == null) {
            Preconditions.checkState((this.featureRegistry != null ? 1 : 0) != 0, (Object)"setGadgetFeatureRegistry must be called before Gadget.getAllFeatures()");
            this.allGadgetFeatures = this.featureRegistry.getFeatures(Lists.newArrayList(this.getDirectFeatureDeps()));
        }
        return this.allGadgetFeatures;
    }

    public Gadget setCurrentView(View currentView) {
        this.currentView = currentView;
        return this;
    }

    public View getCurrentView() {
        return this.currentView;
    }

    public LocaleSpec getLocale() {
        View view = this.getCurrentView();
        String viewName = view == null ? "default" : view.getName();
        return this.spec.getModulePrefs().getLocale(this.context.getLocale(), viewName);
    }

    private void initializeFeatureDeps() {
        if (this.directFeatureDeps == null) {
            this.directFeatureDeps = Sets.newHashSet();
            if (this.context != null) {
                this.directFeatureDeps.addAll(this.spec.getModulePrefs().getViewFeatures(this.context.getView()).keySet());
            } else {
                this.directFeatureDeps.addAll(this.spec.getModulePrefs().getFeatures().keySet());
            }
        }
    }

    public void addFeature(String name) {
        this.initializeFeatureDeps();
        this.directFeatureDeps.add(name);
    }

    public void removeFeature(String name) {
        this.initializeFeatureDeps();
        this.directFeatureDeps.remove(name);
    }

    public Set<String> getDirectFeatureDeps() {
        this.initializeFeatureDeps();
        return Collections.unmodifiableSet(this.directFeatureDeps);
    }

    public Map<String, Feature> getViewFeatures() {
        View view = this.getCurrentView();
        String name = view == null ? "default" : view.getName();
        return this.spec.getModulePrefs().getViewFeatures(name);
    }

    public boolean sanitizeOutput() {
        return this.getCurrentView() != null && this.getCurrentView().getType() == View.ContentType.HTML_SANITIZED || "1".equals(this.getContext().getParameter(UriCommon.Param.SANITIZE.getKey()));
    }

    public boolean requiresCaja() {
        if ("1".equals(this.getContext().getParameter(UriCommon.Param.CAJOLE.getKey()))) {
            return true;
        }
        if (this.featureRegistry != null) {
            return this.getAllFeatures().contains("caja");
        }
        return this.getViewFeatures().containsKey("caja");
    }
}

