/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth2.BasicOAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.GadgetOAuth2TokenStore;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2FetcherConfig;
import org.apache.shindig.gadgets.oauth2.OAuth2Request;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestException;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestParameterGenerator;
import org.apache.shindig.gadgets.oauth2.OAuth2ResponseParams;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.OAuth2Utils;
import org.apache.shindig.gadgets.oauth2.handler.AuthorizationEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.GrantRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;
import org.apache.shindig.gadgets.oauth2.handler.ResourceRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.TokenEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;

public class BasicOAuth2Request
implements OAuth2Request {
    private static final String LOG_CLASS = BasicOAuth2Request.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);
    private static final short MAX_ATTEMPTS = 3;
    private OAuth2Accessor internalAccessor;
    private OAuth2Arguments arguments;
    private final List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers;
    private final List<ClientAuthenticationHandler> clientAuthenticationHandlers;
    private final HttpFetcher fetcher;
    private final OAuth2FetcherConfig fetcherConfig;
    private final List<GrantRequestHandler> grantRequestHandlers;
    private HttpRequest realRequest;
    private final List<ResourceRequestHandler> resourceRequestHandlers;
    private OAuth2ResponseParams responseParams;
    private SecurityToken securityToken;
    private final OAuth2Store store;
    private final List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers;
    private final boolean sendTraceToClient;
    private final OAuth2RequestParameterGenerator requestParameterGenerator;
    private short attemptCounter = 0;

    @Inject
    public BasicOAuth2Request(OAuth2FetcherConfig fetcherConfig, HttpFetcher fetcher, List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers, List<ClientAuthenticationHandler> clientAuthenticationHandlers, List<GrantRequestHandler> grantRequestHandlers, List<ResourceRequestHandler> resourceRequestHandlers, List<TokenEndpointResponseHandler> tokenEndpointResponseHandlers, boolean sendTraceToClient, OAuth2RequestParameterGenerator requestParameterGenerator) {
        this.fetcherConfig = fetcherConfig;
        this.store = this.fetcherConfig != null ? this.fetcherConfig.getOAuth2Store() : null;
        this.fetcher = fetcher;
        this.authorizationEndpointResponseHandlers = authorizationEndpointResponseHandlers;
        this.clientAuthenticationHandlers = clientAuthenticationHandlers;
        this.grantRequestHandlers = grantRequestHandlers;
        this.resourceRequestHandlers = resourceRequestHandlers;
        this.tokenEndpointResponseHandlers = tokenEndpointResponseHandlers;
        this.sendTraceToClient = sendTraceToClient;
        this.requestParameterGenerator = requestParameterGenerator;
        if (LOG.isLoggable()) {
            LOG.log("this.fetcherConfig = {0}", this.fetcherConfig);
            LOG.log("this.store = {0}", this.store);
            LOG.log("this.fetcher = {0}", this.fetcher);
            LOG.log("this.authorizationEndpointResponseHandlers = {0}", this.authorizationEndpointResponseHandlers);
            LOG.log("this.clientAuthenticationHandlers = {0}", this.clientAuthenticationHandlers);
            LOG.log("this.grantRequestHandlers = {0}", this.grantRequestHandlers);
            LOG.log("this.resourceRequestHandlers = {0}", this.resourceRequestHandlers);
            LOG.log("this.tokenEndpointResponseHandlers = {0}", this.tokenEndpointResponseHandlers);
            LOG.log("this.sendTraceToClient = {0}", this.sendTraceToClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse fetch(HttpRequest request) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "fetch", request);
        }
        OAuth2Accessor accessor = null;
        HttpResponse response = null;
        try {
            if (request == null || request.getSecurityToken() == null) {
                response = this.sendErrorResponse(null, OAuth2Error.MISSING_FETCH_PARAMS, "no request or security token");
            } else {
                this.realRequest = request;
                this.securityToken = request.getSecurityToken();
                this.responseParams = new OAuth2ResponseParams();
                this.arguments = this.realRequest.getOAuth2Arguments();
                if (LOG.isLoggable()) {
                    LOG.log("this.realRequest = {0}", this.realRequest);
                    LOG.log("this.securityToken = {0}", this.securityToken);
                    LOG.log("this.responseParams = {0}", this.responseParams);
                    LOG.log("this.arguments = {0}", this.arguments);
                }
                if (this.responseParams == null || this.arguments == null) {
                    HttpResponse httpResponse = this.sendErrorResponse(null, OAuth2Error.FETCH_INIT_PROBLEM, "no responseParams or arguments");
                    return httpResponse;
                }
                accessor = this.getAccessor();
                if (LOG.isLoggable()) {
                    LOG.log("accessor", accessor);
                }
                if (accessor == null) {
                    response = this.sendErrorResponse(null, OAuth2Error.FETCH_INIT_PROBLEM, "accessor is null");
                } else {
                    accessor.setRedirecting(false);
                    Map<String, String> requestParams = this.requestParameterGenerator.generateParams(this.realRequest);
                    accessor.setAdditionalRequestParams(requestParams);
                    HttpResponseBuilder responseBuilder = null;
                    if (!accessor.isErrorResponse()) {
                        responseBuilder = this.attemptFetch(accessor);
                    }
                    response = this.processResponse(accessor, responseBuilder);
                }
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "exception occurred during fetch", t);
            if (accessor == null) {
                accessor = new BasicOAuth2Accessor(t, OAuth2Error.FETCH_PROBLEM, "exception occurred during fetch", "");
            } else {
                accessor.setErrorResponse(t, OAuth2Error.FETCH_PROBLEM, "exception occurred during fetch", "");
            }
            response = this.processResponse(accessor, this.getErrorResponseBuilder(t, OAuth2Error.FETCH_PROBLEM, "exception occurred during fetch"));
        }
        finally {
            if (accessor != null) {
                if (!accessor.isRedirecting()) {
                    if (LOG.isLoggable()) {
                        LOG.log("accessor is not redirecting, remove it", accessor);
                    }
                    accessor.invalidate();
                    this.store.removeOAuth2Accessor(accessor);
                    this.internalAccessor = null;
                } else {
                    if (!accessor.isValid()) {
                        if (LOG.isLoggable()) {
                            LOG.log("accesssor is not valid", accessor);
                        }
                    } else if (accessor.isErrorResponse() && LOG.isLoggable()) {
                        LOG.log("accessor isErrorResponse", accessor.getErrorContextMessage());
                    }
                    this.store.storeOAuth2Accessor(accessor);
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "fetch", response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponseBuilder attemptFetch(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "attemptFetch", new Object[]{accessor});
            LOG.log("BasicOAuth2Request.haveAccessToken(accessor) = {0}", BasicOAuth2Request.haveAccessToken(accessor) != null);
            LOG.log("BasicOAuth2Request.haveRefreshToken(accessor) = {0}", BasicOAuth2Request.haveRefreshToken(accessor) != null);
        }
        if (this.attemptCounter > 3) {
            if (isLogging) {
                LOG.log("MAX_ATTEMPTS exceeded {0}", this.attemptCounter);
                StackTraceElement[] stackElements = Thread.currentThread().getStackTrace();
                String stack = "";
                for (StackTraceElement element : stackElements) {
                    stack = stack + element.toString() + "\n";
                }
                LOG.log("MAX_ATTEMPTS stack = {0}", stack);
            }
            return this.fetchData(accessor, true);
        }
        this.attemptCounter = (short)(this.attemptCounter + 1);
        if (isLogging) {
            LOG.log("attempt number {0}", this.attemptCounter);
        }
        HttpResponseBuilder ret = null;
        if (accessor.isErrorResponse()) {
            return this.getErrorResponseBuilder(accessor.getErrorException(), accessor.getError(), accessor.getErrorContextMessage(), accessor.getErrorUri(), accessor.getErrorContextMessage());
        }
        if (BasicOAuth2Request.haveAccessToken(accessor) != null) {
            ret = this.fetchData(accessor, this.attemptCounter > 3);
        } else if (BasicOAuth2Request.haveRefreshToken(accessor) != null) {
            if (BasicOAuth2Request.checkCanRefresh()) {
                boolean attempt = false;
                String internedAccessor = BasicOAuth2Request.getAccessorKey(accessor).intern();
                if (isLogging) {
                    LOG.log("about to synchronize on {0}", internedAccessor);
                }
                String string = internedAccessor;
                synchronized (string) {
                    OAuth2Accessor acc = this.getAccessorInternal();
                    if (isLogging) {
                        LOG.log("acc = {0}", acc);
                        LOG.log("BasicOAuth2Request.haveAccessToken(acc) = {0}", BasicOAuth2Request.haveAccessToken(acc) == null);
                        LOG.log("BasicOAuth2Request.haveRefreshToken(acc) = {0}", BasicOAuth2Request.haveRefreshToken(acc) == null);
                    }
                    if (BasicOAuth2Request.haveAccessToken(acc) != null) {
                        if (isLogging) {
                            LOG.log("found an access token from another refresh", new Object[0]);
                        }
                        attempt = true;
                    } else {
                        OAuth2HandlerError handlerError = this.refreshToken(accessor);
                        if (handlerError == null) {
                            attempt = true;
                            if (isLogging) {
                                LOG.log("no refresh errors reported", new Object[0]);
                            }
                        } else {
                            if (isLogging) {
                                LOG.log("refresh errors reported", new Object[0]);
                            }
                            OAuth2Error error = handlerError.getError();
                            ret = this.getErrorResponseBuilder(handlerError.getCause(), error, handlerError.getContextMessage(), handlerError.getUri(), handlerError.getDescription());
                        }
                    }
                }
                if (attempt) {
                    if (isLogging) {
                        LOG.log("going to re-attempt with a clean accesor", new Object[0]);
                    }
                    this.store.removeOAuth2Accessor(this.internalAccessor);
                    this.internalAccessor = null;
                    ret = this.attemptFetch(this.getAccessor());
                }
            } else {
                accessor.setAccessToken(null);
                accessor.setRefreshToken(null);
                ret = this.attemptFetch(accessor);
            }
        } else if (!accessor.isRedirecting() && this.checkCanAuthorize(accessor)) {
            String completeAuthUrl = this.authorize(accessor);
            if (completeAuthUrl != null) {
                this.responseParams.setAuthorizationUrl(completeAuthUrl);
                accessor.setRedirecting(true);
            } else {
                ret = this.attemptFetch(accessor);
            }
        }
        if (ret == null) {
            if (accessor.isRedirecting()) {
                ret = new HttpResponseBuilder().setHttpStatusCode(200).setStrictNoCache();
            } else {
                accessor.setAccessToken(null);
                ret = this.attemptFetch(accessor);
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "attemptFetch", ret);
        }
        return ret;
    }

    private String authorize(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "authorize", accessor);
        }
        String ret = null;
        String grantType = accessor.getGrantType();
        GrantRequestHandler grantRequestHandlerUsed = null;
        for (GrantRequestHandler grantRequestHandler : this.grantRequestHandlers) {
            if (!grantRequestHandler.getGrantType().equalsIgnoreCase(grantType)) continue;
            grantRequestHandlerUsed = grantRequestHandler;
            break;
        }
        if (grantRequestHandlerUsed == null) {
            accessor.setErrorResponse(null, OAuth2Error.AUTHENTICATION_PROBLEM, "no grantRequestHandler found for " + grantType, "");
        } else {
            String completeAuthUrl;
            block10: {
                completeAuthUrl = null;
                try {
                    completeAuthUrl = grantRequestHandlerUsed.getCompleteUrl(accessor);
                }
                catch (OAuth2RequestException e) {
                    if (!isLogging) break block10;
                    LOG.log("error getting complete url", e);
                }
            }
            if (grantRequestHandlerUsed.isRedirectRequired()) {
                ret = completeAuthUrl;
            } else {
                OAuth2HandlerError error = this.authorize(accessor, grantRequestHandlerUsed, completeAuthUrl);
                if (error != null) {
                    accessor.setErrorResponse(error.getCause(), OAuth2Error.AUTHENTICATION_PROBLEM, error.getContextMessage() + " , " + error.getDescription(), error.getUri());
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "authorize", ret);
        }
        return ret;
    }

    private OAuth2HandlerError authorize(OAuth2Accessor accessor, GrantRequestHandler grantRequestHandler, String completeAuthUrl) {
        HttpRequest authorizationRequest;
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "authorize", new Object[]{accessor, grantRequestHandler, completeAuthUrl});
        }
        OAuth2HandlerError ret = null;
        try {
            authorizationRequest = grantRequestHandler.getAuthorizationRequest(accessor, completeAuthUrl);
        }
        catch (OAuth2RequestException e) {
            authorizationRequest = null;
            ret = new OAuth2HandlerError(e.getError(), e.getErrorText(), e);
        }
        if (isLogging) {
            LOG.log("authorizationRequest = {0}", authorizationRequest);
        }
        if (authorizationRequest != null) {
            HttpResponse authorizationResponse;
            try {
                authorizationResponse = this.fetcher.fetch(authorizationRequest);
            }
            catch (GadgetException e) {
                if (isLogging) {
                    LOG.log("authorize()", e);
                }
                authorizationResponse = null;
                ret = new OAuth2HandlerError(OAuth2Error.AUTHORIZE_PROBLEM, "exception thrown fetching authorization", e);
            }
            if (isLogging) {
                LOG.log("authorizationResponse = {0}", authorizationResponse);
            }
            if (authorizationResponse != null) {
                if (grantRequestHandler.isAuthorizationEndpointResponse()) {
                    for (AuthorizationEndpointResponseHandler authorizationEndpointResponseHandler : this.authorizationEndpointResponseHandlers) {
                        if (!authorizationEndpointResponseHandler.handlesResponse(accessor, authorizationResponse)) continue;
                        if (isLogging) {
                            LOG.log("using AuthorizationEndpointResponseHandler = {0}", authorizationEndpointResponseHandler);
                        }
                        if ((ret = authorizationEndpointResponseHandler.handleResponse(accessor, authorizationResponse)) == null) continue;
                        break;
                    }
                }
                if (ret == null && grantRequestHandler.isTokenEndpointResponse()) {
                    for (TokenEndpointResponseHandler tokenEndpointResponseHandler : this.tokenEndpointResponseHandlers) {
                        if (!tokenEndpointResponseHandler.handlesResponse(accessor, authorizationResponse)) continue;
                        if (isLogging) {
                            LOG.log("using TokenEndpointResponseHandler = {0}", tokenEndpointResponseHandler);
                        }
                        if ((ret = tokenEndpointResponseHandler.handleResponse(accessor, authorizationResponse)) == null) continue;
                        break;
                    }
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "authorize", ret);
        }
        return ret;
    }

    private static String buildRefreshTokenUrl(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "buildRefreshTokenUrl", accessor);
        }
        String ret = null;
        String refreshUrl = accessor.getTokenUrl();
        if (refreshUrl != null) {
            ret = BasicOAuth2Request.getCompleteRefreshUrl(refreshUrl);
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "buildRefreshTokenUrl", ret);
        }
        return ret;
    }

    private boolean checkCanAuthorize(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "checkCanAuthorize", accessor);
        }
        boolean ret = true;
        if (LOG.isLoggable()) {
            LOG.log("securityToken = {0}", this.securityToken);
        }
        String pageOwner = this.securityToken.getOwnerId();
        String pageViewer = this.securityToken.getViewerId();
        if (LOG.isLoggable()) {
            LOG.log("pageOwner = {0}", pageOwner);
            LOG.log("pageViewer = {0}", pageViewer);
        }
        if (pageOwner == null || pageViewer == null) {
            accessor.setErrorResponse(null, OAuth2Error.AUTHORIZE_PROBLEM, "pageOwner or pageViewer is null", "");
            ret = false;
        } else if (!this.fetcherConfig.isViewerAccessTokensEnabled() && !pageOwner.equals(pageViewer)) {
            accessor.setErrorResponse(null, OAuth2Error.AUTHORIZE_PROBLEM, "pageViewer is not pageOwner", "");
            ret = false;
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "checkCanAuthorize", ret);
        }
        return ret;
    }

    private static boolean checkCanRefresh() {
        return true;
    }

    private HttpResponseBuilder fetchData(OAuth2Accessor accessor, boolean lastAttempt) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "fetchData", accessor);
        }
        HttpResponseBuilder ret = null;
        try {
            HttpResponse response = this.fetchFromServer(accessor, this.realRequest, lastAttempt);
            if (response != null) {
                ret = new HttpResponseBuilder(response);
                if (response.getHttpStatusCode() != 200 && this.sendTraceToClient) {
                    this.responseParams.addRequestTrace(this.realRequest, response);
                }
            }
        }
        catch (OAuth2RequestException e) {
            ret = this.getErrorResponseBuilder(e, e.getError(), e.getErrorText(), e.getErrorUri(), e.getErrorDescription());
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "fetchData", ret);
        }
        return ret;
    }

    private HttpResponse fetchFromServer(OAuth2Accessor accessor, HttpRequest request, boolean lastAttempt) throws OAuth2RequestException {
        HttpResponse ret;
        long expiresAt;
        OAuth2Token refreshToken;
        long expiresAt2;
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "fetchFromServer", new Object[]{accessor, "only log request once", lastAttempt});
        }
        long currentTime = System.currentTimeMillis();
        OAuth2Token accessToken = accessor.getAccessToken();
        if (accessToken != null && (expiresAt2 = accessToken.getExpiresAt()) != 0L && currentTime >= expiresAt2) {
            if (LOG.isLoggable()) {
                LOG.log("accessToken has expired at {0}", expiresAt2);
            }
            try {
                this.store.removeToken(accessToken);
            }
            catch (GadgetException e) {
                throw new OAuth2RequestException(OAuth2Error.MISSING_SERVER_RESPONSE, "error removing access_token", null);
            }
            accessToken = null;
            accessor.setAccessToken(null);
            if (!lastAttempt) {
                return null;
            }
        }
        if ((refreshToken = accessor.getRefreshToken()) != null && (expiresAt = refreshToken.getExpiresAt()) != 0L && currentTime >= expiresAt) {
            if (LOG.isLoggable()) {
                LOG.log("refreshToken has expired at {0}", expiresAt);
            }
            try {
                this.store.removeToken(refreshToken);
            }
            catch (GadgetException e) {
                throw new OAuth2RequestException(OAuth2Error.MISSING_SERVER_RESPONSE, "error removing refresh_token", null);
            }
            refreshToken = null;
            accessor.setRefreshToken(null);
            if (!lastAttempt) {
                return null;
            }
        }
        if (LOG.isLoggable()) {
            LOG.log("accessToken = {0}", accessToken);
            LOG.log("refreshToken = {0}", refreshToken);
        }
        if (accessToken != null) {
            boolean isAllowed = OAuth2Utils.isUriAllowed(request.getUri(), accessor.getAllowedDomains());
            if (isAllowed) {
                String tokenType = accessToken.getTokenType();
                if (tokenType == null || tokenType.length() == 0) {
                    tokenType = "Bearer";
                }
                for (ResourceRequestHandler resourceRequestHandler : this.resourceRequestHandlers) {
                    if (!tokenType.equalsIgnoreCase(resourceRequestHandler.getTokenType())) continue;
                    resourceRequestHandler.addOAuth2Params(accessor, request);
                }
            } else {
                LOG.log(Level.WARNING, "Gadget {0} attempted to send OAuth2 Token to an unauthorized domain: {1}.", new Object[]{accessor.getGadgetUri(), request.getUri()});
            }
        }
        try {
            ret = this.fetcher.fetch(request);
        }
        catch (GadgetException e) {
            throw new OAuth2RequestException(OAuth2Error.MISSING_SERVER_RESPONSE, "GadgetException fetchFromServer", e);
        }
        if (ret == null) {
            throw new OAuth2RequestException(OAuth2Error.MISSING_SERVER_RESPONSE, "response is null", null);
        }
        int responseCode = ret.getHttpStatusCode();
        if (isLogging) {
            LOG.log("responseCode = {0}", responseCode);
        }
        if (responseCode == 401) {
            if (accessToken != null) {
                try {
                    this.store.removeToken(accessToken);
                }
                catch (GadgetException e) {
                    throw new OAuth2RequestException(OAuth2Error.MISSING_SERVER_RESPONSE, "error removing access_token", null);
                }
                accessor.setAccessToken(null);
            }
            if (!lastAttempt) {
                ret = null;
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "fetchFromServer", ret);
        }
        return ret;
    }

    private OAuth2Accessor getAccessorInternal() {
        GadgetOAuth2TokenStore tokenStore;
        OAuth2Accessor ret = null;
        if (this.fetcherConfig != null && (tokenStore = this.fetcherConfig.getTokenStore()) != null) {
            ret = tokenStore.getOAuth2Accessor(this.securityToken, this.arguments, this.realRequest.getGadget());
        }
        return ret;
    }

    private OAuth2Accessor getAccessor() {
        if (this.internalAccessor == null || !this.internalAccessor.isValid()) {
            this.internalAccessor = this.getAccessorInternal();
        }
        return this.internalAccessor;
    }

    private static String getCompleteRefreshUrl(String refreshUrl) {
        return OAuth2Utils.buildUrl(refreshUrl, null, null);
    }

    private HttpResponseBuilder getErrorResponseBuilder(Throwable t, OAuth2Error error, String contextMessage) {
        return this.getErrorResponseBuilder(t, error, contextMessage, null, null);
    }

    private HttpResponseBuilder getErrorResponseBuilder(Throwable t, OAuth2Error error, String contextMessage, String errorUri, String errorDescription) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "getErrorResponseBuilder", new Object[]{t, error, contextMessage, errorUri, errorDescription});
        }
        HttpResponseBuilder ret = new HttpResponseBuilder().setHttpStatusCode(403).setStrictNoCache();
        if (t != null && this.sendTraceToClient) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            String message = sw.toString();
            this.responseParams.addDebug(message);
        }
        if (this.sendTraceToClient) {
            this.responseParams.addToResponse(ret, error.getErrorCode(), error.getErrorDescription(contextMessage) + " , " + errorDescription, errorUri, error.getErrorExplanation());
        } else {
            this.responseParams.addToResponse(ret, error.getErrorCode(), "", "", error.getErrorExplanation());
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "getErrorResponseBuilder", ret);
        }
        return ret;
    }

    private static String getRefreshBody(OAuth2Accessor accessor) {
        String ret;
        block6: {
            boolean isLogging = LOG.isLoggable();
            if (isLogging) {
                LOG.entering(LOG_CLASS, "getRefreshBody", accessor);
            }
            ret = "";
            try {
                HashMap queryParams = Maps.newHashMap();
                queryParams.put("grant_type", "refresh_token");
                queryParams.put("refresh_token", new String(accessor.getRefreshToken().getSecret(), "UTF-8"));
                if (accessor.getScope() != null && accessor.getScope().length() > 0) {
                    queryParams.put("scope", accessor.getScope());
                }
                String clientId = accessor.getClientId();
                byte[] secret = accessor.getClientSecret();
                queryParams.put("client_id", clientId);
                queryParams.put("client_secret", new String(secret, "UTF-8"));
                ret = OAuth2Utils.buildUrl(ret, queryParams, null);
                char firstChar = ret.charAt(0);
                if (firstChar == '?' || firstChar == '&') {
                    ret = ret.substring(1);
                }
                if (isLogging) {
                    LOG.exiting(LOG_CLASS, "getRefreshBody", ret);
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!isLogging) break block6;
                LOG.log("error generating refresh body", e);
                ret = null;
            }
        }
        return ret;
    }

    private HttpResponse processResponse(OAuth2Accessor accessor, HttpResponseBuilder responseBuilder) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "processResponse", new Object[]{accessor, responseBuilder == null});
        }
        if (accessor.isErrorResponse() || responseBuilder == null) {
            return this.sendErrorResponse(accessor.getErrorException(), accessor.getError(), accessor.getErrorContextMessage(), accessor.getErrorUri(), "");
        }
        if (this.responseParams.getAuthorizationUrl() != null) {
            responseBuilder.setMetadata("oauthApprovalUrl", this.responseParams.getAuthorizationUrl());
            accessor.setRedirecting(true);
        } else {
            accessor.setRedirecting(false);
        }
        HttpResponse ret = responseBuilder.create();
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "processResponse", "response logged in fetch()");
        }
        return ret;
    }

    private OAuth2HandlerError refreshToken(OAuth2Accessor accessor) {
        boolean isLogging = LOG.isLoggable();
        if (isLogging) {
            LOG.entering(LOG_CLASS, "refreshToken", new Object[]{accessor});
        }
        OAuth2HandlerError ret = null;
        String refershTokenUrl = BasicOAuth2Request.buildRefreshTokenUrl(accessor);
        if (isLogging) {
            LOG.log("refershTokenUrl = {0}", refershTokenUrl);
        }
        if (refershTokenUrl != null) {
            HttpResponse response = null;
            HttpRequest request = new HttpRequest(Uri.parse((String)refershTokenUrl));
            request.setSecurityToken((SecurityToken)new AnonymousSecurityToken("", Long.valueOf(0L), accessor.getGadgetUri()));
            request.setMethod("POST");
            request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
            for (ClientAuthenticationHandler clientAuthenticationHandler : this.clientAuthenticationHandlers) {
                if (!clientAuthenticationHandler.geClientAuthenticationType().equalsIgnoreCase(accessor.getClientAuthenticationType())) continue;
                clientAuthenticationHandler.addOAuth2Authentication(request, accessor);
            }
            try {
                byte[] body = BasicOAuth2Request.getRefreshBody(accessor).getBytes("UTF-8");
                request.setPostBody(body);
            }
            catch (Exception e) {
                if (isLogging) {
                    LOG.log("refreshToken()", e);
                }
                ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "error generating refresh body", e);
            }
            if (!OAuth2Utils.isUriAllowed(request.getUri(), accessor.getAllowedDomains())) {
                ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "error fetching refresh token - domain not allowed", null);
            }
            if (ret == null) {
                try {
                    response = this.fetcher.fetch(request);
                }
                catch (GadgetException e) {
                    if (isLogging) {
                        LOG.log("refreshToken()", e);
                    }
                    ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "error fetching refresh token", e);
                }
                if (isLogging) {
                    LOG.log("response = {0}", response);
                }
                if (response == null) {
                    ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "response is null", null);
                }
                if (ret == null) {
                    int statusCode = response.getHttpStatusCode();
                    if (statusCode == 401 || statusCode == 400) {
                        try {
                            this.store.removeToken(accessor.getRefreshToken());
                        }
                        catch (GadgetException e) {
                            ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "failed to remove refresh token", e);
                        }
                        accessor.setRefreshToken(null);
                        if (isLogging) {
                            LOG.log(Level.FINEST, "received {0} from provider, removed refresh token.  response = {1}", new Object[]{statusCode, response.getResponseAsString()});
                        }
                        return null;
                    }
                    if (statusCode != 200) {
                        ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, "bad response from server : " + statusCode, null, "", response.getResponseAsString());
                    }
                    if (ret == null) {
                        for (TokenEndpointResponseHandler tokenEndpointResponseHandler : this.tokenEndpointResponseHandlers) {
                            OAuth2HandlerError error;
                            if (!tokenEndpointResponseHandler.handlesResponse(accessor, response) || (error = tokenEndpointResponseHandler.handleResponse(accessor, response)) == null) continue;
                            try {
                                this.store.removeToken(accessor.getRefreshToken());
                            }
                            catch (GadgetException e) {
                                ret = new OAuth2HandlerError(OAuth2Error.REFRESH_TOKEN_PROBLEM, error.getContextMessage(), e, error.getUri(), error.getDescription());
                            }
                            accessor.setRefreshToken(null);
                            return error;
                        }
                    }
                }
            }
        }
        if (isLogging) {
            LOG.exiting(LOG_CLASS, "refreshToken", ret);
        }
        return ret;
    }

    private HttpResponse sendErrorResponse(Throwable t, OAuth2Error error, String contextMessage) {
        HttpResponseBuilder responseBuilder = this.getErrorResponseBuilder(t, error, contextMessage);
        return responseBuilder.create();
    }

    private HttpResponse sendErrorResponse(Throwable t, OAuth2Error error, String contextMessage, String errorUri, String errorDescription) {
        HttpResponseBuilder responseBuilder = this.getErrorResponseBuilder(t, error, contextMessage, errorUri, errorDescription);
        return responseBuilder.create();
    }

    private static OAuth2Token haveAccessToken(OAuth2Accessor accessor) {
        OAuth2Token ret = accessor.getAccessToken();
        if (ret != null && !BasicOAuth2Request.validateAccessToken(ret)) {
            ret = null;
        }
        return ret;
    }

    private static OAuth2Token haveRefreshToken(OAuth2Accessor accessor) {
        OAuth2Token ret = accessor.getRefreshToken();
        if (ret != null && !BasicOAuth2Request.validateRefreshToken(ret)) {
            ret = null;
        }
        return ret;
    }

    private static boolean validateAccessToken(OAuth2Token accessToken) {
        return accessToken != null;
    }

    private static boolean validateRefreshToken(OAuth2Token refreshToken) {
        return refreshToken != null;
    }

    private static String getAccessorKey(OAuth2Accessor accessor) {
        if (accessor != null) {
            return "accessor:" + accessor.getGadgetUri() + ':' + accessor.getServiceName() + ':' + accessor.getUser() + ':' + accessor.getScope();
        }
        return null;
    }
}

