/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestException;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Encrypter;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2EncryptionException;

public class OAuth2TokenPersistence
implements OAuth2Token {
    private static final long serialVersionUID = -169781729667228661L;
    private byte[] encryptedMacSecret;
    private byte[] encryptedSecret;
    private final transient OAuth2Encrypter encrypter;
    private long expiresAt;
    private String gadgetUri;
    private long issuedAt;
    private String macAlgorithm;
    private String macExt;
    private byte[] macSecret;
    private final Map<String, String> properties;
    private String scope;
    private byte[] secret;
    private String serviceName;
    private String tokenType;
    private OAuth2Token.Type type;
    private String user;

    public OAuth2TokenPersistence() {
        this(null);
    }

    @Inject
    public OAuth2TokenPersistence(OAuth2Encrypter encrypter) {
        this.encrypter = encrypter;
        this.properties = Maps.newHashMap();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OAuth2Token)) {
            return false;
        }
        OAuth2Token other = (OAuth2Token)obj;
        if (this.gadgetUri == null ? other.getGadgetUri() != null : !this.gadgetUri.equals(other.getGadgetUri())) {
            return false;
        }
        if (this.serviceName == null ? other.getServiceName() != null : !this.serviceName.equals(other.getServiceName())) {
            return false;
        }
        if (this.user == null ? other.getUser() != null : !this.user.equals(other.getUser())) {
            return false;
        }
        if (this.scope == null ? other.getScope() != null : !this.scope.equals(other.getScope())) {
            return false;
        }
        return !(this.type == null ? other.getType() != null : !this.type.equals((Object)other.getType()));
    }

    public byte[] getEncryptedMacSecret() {
        return this.encryptedMacSecret;
    }

    public byte[] getEncryptedSecret() {
        return this.encryptedSecret;
    }

    @Override
    public long getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public String getGadgetUri() {
        return this.gadgetUri;
    }

    @Override
    public long getIssuedAt() {
        return this.issuedAt;
    }

    @Override
    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    @Override
    public String getMacExt() {
        return this.macExt;
    }

    @Override
    public byte[] getMacSecret() {
        return this.macSecret;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public byte[] getSecret() {
        return this.secret;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getTokenType() {
        if (this.tokenType == null || this.tokenType.length() == 0) {
            this.tokenType = "Bearer";
        }
        return this.tokenType;
    }

    @Override
    public OAuth2Token.Type getType() {
        return this.type;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        if (this.serviceName != null && this.gadgetUri != null) {
            return (this.serviceName + ':' + this.gadgetUri + ':' + this.user + ':' + this.scope + ':' + (Object)((Object)this.type)).hashCode();
        }
        return 0;
    }

    public void setEncryptedMacSecret(byte[] encryptedSecret) throws OAuth2EncryptionException {
        this.encryptedMacSecret = encryptedSecret;
        this.macSecret = this.encrypter == null ? encryptedSecret : this.encrypter.decrypt(encryptedSecret);
    }

    public void setEncryptedSecret(byte[] encryptedSecret) throws OAuth2EncryptionException {
        this.encryptedSecret = encryptedSecret;
        this.secret = this.encrypter == null ? encryptedSecret : this.encrypter.decrypt(encryptedSecret);
    }

    @Override
    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Override
    public void setGadgetUri(String gadgetUri) {
        this.gadgetUri = gadgetUri;
    }

    @Override
    public void setIssuedAt(long issuedAt) {
        this.issuedAt = issuedAt;
    }

    @Override
    public void setMacAlgorithm(String algorithm) {
        this.macAlgorithm = algorithm;
    }

    public void setMacExt(String macExt) {
        this.macExt = macExt;
    }

    @Override
    public void setMacSecret(byte[] secret) throws OAuth2RequestException {
        this.macSecret = secret;
        try {
            this.encryptedMacSecret = this.encrypter == null ? secret : this.encrypter.encrypt(secret);
        }
        catch (OAuth2EncryptionException e) {
            throw new OAuth2RequestException(OAuth2Error.SECRET_ENCRYPTION_PROBLEM, "OAuth2TokenPersistence could not encrypt the mac secret", e);
        }
    }

    @Override
    public void setProperties(Map<String, String> properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setSecret(byte[] secret) throws OAuth2RequestException {
        this.secret = secret;
        try {
            this.encryptedSecret = this.encrypter == null ? secret : this.encrypter.encrypt(secret);
        }
        catch (OAuth2EncryptionException e) {
            throw new OAuth2RequestException(OAuth2Error.SECRET_ENCRYPTION_PROBLEM, "OAuth2TokenPersistence could not encrypt the token secret", e);
        }
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public void setType(OAuth2Token.Type type) {
        this.type = type;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
    }

    public String toString() {
        return "org.apache.shindig.gadgets.oauth2.persistence.sample.OAuth2TokenImpl: serviceName = " + this.serviceName + " , user = " + this.user + " , gadgetUri = " + this.gadgetUri + " , scope = " + this.scope + " , tokenType = " + this.getTokenType() + " , issuedAt = " + this.issuedAt + " , expiresAt = " + this.expiresAt + " , type = " + (Object)((Object)this.type);
    }
}

