/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class SanitizingProxyUriManager
implements ProxyUriManager {
    private final ProxyUriManager wrapped;
    private final String expectedMime;

    public SanitizingProxyUriManager(ProxyUriManager wrapped, String expectedMime) {
        this.wrapped = wrapped;
        this.expectedMime = expectedMime;
    }

    @Override
    public ProxyUriManager.ProxyUri process(Uri uri) throws GadgetException {
        return this.wrapped.process(uri);
    }

    @Override
    public List<Uri> make(List<ProxyUriManager.ProxyUri> ctx, Integer forcedRefresh) {
        for (ProxyUriManager.ProxyUri proxyUri : ctx) {
            proxyUri.setSanitizeContent(true);
            if (this.expectedMime == null) continue;
            proxyUri.setRewriteMimeType(this.expectedMime);
        }
        return this.wrapped.make(ctx, forcedRefresh);
    }
}

