/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite.image;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.Sanselan;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.rewrite.image.BaseOptimizer;
import org.apache.shindig.gadgets.rewrite.image.ImageUtils;
import org.apache.shindig.gadgets.rewrite.image.OptimizerConfig;
import org.apache.shindig.gadgets.rewrite.image.PNGOptimizer;

public class GIFOptimizer
extends PNGOptimizer {
    private boolean usePng;

    public static BufferedImage readGif(InputStream is) throws ImageReadException, IOException {
        return Sanselan.getBufferedImage((InputStream)is);
    }

    public GIFOptimizer(OptimizerConfig config, HttpResponseBuilder response) {
        super(config, response);
    }

    @Override
    protected void rewriteImpl(BufferedImage image) throws IOException {
        if (!ImageUtils.isOpaque(image)) {
            this.write(ImageUtils.palettize(image, Integer.MAX_VALUE));
        } else {
            this.usePng = true;
            this.outputter = new BaseOptimizer.ImageIOOutputter(ImageIO.getImageWritersByFormatName("png").next(), null);
            super.rewriteImpl(image);
        }
    }

    @Override
    protected String getOriginalContentType() {
        return "image/gif";
    }

    @Override
    protected String getOutputContentType() {
        if (this.usePng) {
            return super.getOutputContentType();
        }
        return "image/gif";
    }

    @Override
    protected String getOriginalFormatName() {
        return "gif";
    }
}

