/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.AuthInfoUtil;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth2.OAuth2Arguments;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterList;
import org.apache.shindig.gadgets.rewrite.ResponseRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewriterRegistry;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.servlet.HttpGadgetContext;
import org.apache.shindig.gadgets.servlet.HttpRequestHandler;
import org.apache.shindig.gadgets.servlet.ServletUtil;
import org.apache.shindig.gadgets.uri.UriCommon;

@Singleton
public class MakeRequestHandler
implements ContainerConfig.ConfigObserver {
    public static final String ALIAS_PARAM = "alias";
    public static final String POST_DATA_PARAM = "postData";
    public static final String METHOD_PARAM = "httpMethod";
    public static final String HEADERS_PARAM = "headers";
    public static final String CONTENT_TYPE_PARAM = "contentType";
    public static final String NUM_ENTRIES_PARAM = "numEntries";
    public static final String DEFAULT_NUM_ENTRIES = "3";
    public static final String GET_SUMMARIES_PARAM = "getSummaries";
    public static final String GET_FULL_HEADERS_PARAM = "getFullHeaders";
    public static final String AUTHZ_PARAM = "authz";
    public static final String MAX_POST_SIZE_KEY = "gadgets.jsonProxyUrl.maxPostSize";
    public static final String MULTI_PART_FORM_POST = "MPFP";
    public static final String MULTI_PART_FORM_POST_IFRAME = "iframe";
    public static final String GADGETS_FEATURES = "gadgets.features";
    public static final String CORE_IO = "core.io";
    public static final String UNPARSEABLE_CRUFT = "unparseableCruft";
    public static final int MAX_POST_SIZE_DEFAULT = 0x500000;
    public static final String IFRAME_RESPONSE_PREFIX = "<html><head></head><body><textarea></textarea><script type='text/javascript'>document.getElementsByTagName('TEXTAREA')[0].value='";
    public static final String IFRAME_RESPONSE_SUFFIX = "';</script></body></html>";
    private final Map<String, String> unparseableCruftMsgs;
    private final RequestPipeline requestPipeline;
    private final ResponseRewriterRegistry contentRewriterRegistry;
    private final Provider<FeedProcessor> feedProcessorProvider;
    private final GadgetAdminStore gadgetAdminStore;
    private final Processor processor;
    private final LockedDomainService lockedDomainService;
    private final Map<String, Integer> maxPostSizes;

    @Inject
    public MakeRequestHandler(ContainerConfig config, RequestPipeline requestPipeline, @RewriterRegistry(rewriteFlow=ResponseRewriterList.RewriteFlow.DEFAULT) ResponseRewriterRegistry contentRewriterRegistry, Provider<FeedProcessor> feedProcessorProvider, GadgetAdminStore gadgetAdminStore, Processor processor, LockedDomainService lockedDomainService) {
        this.requestPipeline = requestPipeline;
        this.contentRewriterRegistry = contentRewriterRegistry;
        this.feedProcessorProvider = feedProcessorProvider;
        this.gadgetAdminStore = gadgetAdminStore;
        this.processor = processor;
        this.lockedDomainService = lockedDomainService;
        this.maxPostSizes = Maps.newConcurrentMap();
        this.unparseableCruftMsgs = Maps.newConcurrentMap();
        config.addConfigObserver((ContainerConfig.ConfigObserver)this, true);
    }

    public void fetch(HttpServletRequest request, HttpServletResponse response) throws GadgetException, IOException {
        Gadget gadget;
        HttpRequest rcr = this.buildHttpRequest(request);
        String container = rcr.getContainer();
        final Uri gadgetUri = rcr.getGadget();
        if (gadgetUri == null) {
            throw new GadgetException(GadgetException.Code.MISSING_PARAMETER, "Unable to find gadget in request", 403);
        }
        HttpGadgetContext context = new HttpGadgetContext(request){

            @Override
            public Uri getUrl() {
                return gadgetUri;
            }

            @Override
            public boolean getIgnoreCache() {
                return this.getParameter("bypassSpecCache").equals("1");
            }
        };
        try {
            gadget = this.processor.process(context);
        }
        catch (ProcessingException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Error processing gadget", e, 400);
        }
        if (!this.lockedDomainService.isGadgetValidForHost(((GadgetContext)context).getHost(), gadget, container)) {
            throw new GadgetException(GadgetException.Code.GADGET_HOST_MISMATCH, "The gadget is incorrect for this request", 403);
        }
        if (!this.gadgetAdminStore.isWhitelisted(container, gadgetUri.toString())) {
            throw new GadgetException(GadgetException.Code.NON_WHITELISTED_GADGET, "The requested content is unavailable", 403);
        }
        HttpResponse results = this.requestPipeline.execute(rcr);
        if (this.contentRewriterRegistry != null) {
            try {
                results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results, gadget);
            }
            catch (RewritingException e) {
                throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, e.getHttpStatusCode());
            }
        }
        String output = this.convertResponseToJson(rcr.getSecurityToken(), request, results);
        this.setResponseHeaders(request, response, results);
        response.setStatus(200);
        response.setCharacterEncoding("UTF-8");
        PrintWriter out = response.getWriter();
        if ("1".equals(MakeRequestHandler.getParameter(request, MULTI_PART_FORM_POST_IFRAME, null))) {
            response.setContentType("text/html");
            out.write(IFRAME_RESPONSE_PREFIX);
            out.write(StringEscapeUtils.escapeEcmaScript((String)this.unparseableCruftMsgs.get(container)));
            out.write(StringEscapeUtils.escapeEcmaScript((String)output));
            out.write(IFRAME_RESPONSE_SUFFIX);
        } else {
            response.setContentType("application/json");
            out.write(this.unparseableCruftMsgs.get(container) + output);
        }
    }

    protected HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        String userAgent;
        String headerData;
        Uri url;
        String urlStr = MakeRequestHandler.getParameter(request, UriCommon.Param.URL.getKey(), null);
        if (urlStr == null) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, UriCommon.Param.URL.getKey() + " parameter is missing.", 400);
        }
        try {
            url = ServletUtil.validateUrl(Uri.parse((String)urlStr));
        }
        catch (IllegalArgumentException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Invalid " + UriCommon.Param.URL.getKey() + " parameter", 400);
        }
        SecurityToken token = AuthInfoUtil.getSecurityTokenFromRequest((HttpServletRequest)request);
        String container = null;
        Uri gadgetUri = null;
        if ("1".equals(MakeRequestHandler.getParameter(request, MULTI_PART_FORM_POST, null)) && token == null) {
            throw new GadgetException(GadgetException.Code.INVALID_SECURITY_TOKEN);
        }
        if (token != null && !token.isAnonymous()) {
            container = token.getContainer();
            String appurl = token.getAppUrl();
            if (appurl != null) {
                gadgetUri = Uri.parse((String)appurl);
            }
        } else {
            container = MakeRequestHandler.getContainer(request);
            String gadgetUrl = MakeRequestHandler.getParameter(request, UriCommon.Param.GADGET.getKey(), null);
            if (gadgetUrl != null) {
                gadgetUri = Uri.parse((String)gadgetUrl);
            }
        }
        HttpRequest req = new HttpRequest(url).setMethod(MakeRequestHandler.getParameter(request, METHOD_PARAM, "GET")).setContainer(container).setGadget(gadgetUri);
        if ("POST".equals(req.getMethod()) || "PUT".equals(req.getMethod())) {
            this.setPostData(container, request, req);
        }
        if ((headerData = MakeRequestHandler.getParameter(request, HEADERS_PARAM, "")).length() > 0) {
            String[] headerList;
            for (String header : headerList = StringUtils.split((String)headerData, (char)'&')) {
                String[] parts = StringUtils.splitPreserveAllTokens((String)header, (char)'=');
                if (parts.length != 2) {
                    throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "Malformed header param specified:" + header, 400);
                }
                String headerName = Utf8UrlCoder.decode((String)parts[0]);
                if (HttpRequestHandler.BAD_HEADERS.contains(headerName.toUpperCase())) continue;
                req.addHeader(headerName, Utf8UrlCoder.decode((String)parts[1]));
            }
        }
        if ("POST".equals(req.getMethod()) && req.getHeader("Content-Type") == null) {
            req.addHeader("Content-Type", "application/x-www-form-urlencoded");
        } else if ("1".equals(MakeRequestHandler.getParameter(request, MULTI_PART_FORM_POST, null))) {
            req.setHeader("Content-Type", request.getHeader("Content-Type"));
        }
        req.setIgnoreCache("1".equals(MakeRequestHandler.getParameter(request, UriCommon.Param.NO_CACHE.getKey(), null)));
        String refresh = MakeRequestHandler.getParameter(request, UriCommon.Param.REFRESH.getKey(), null);
        if (refresh != null) {
            try {
                req.setCacheTtl(Integer.parseInt(refresh));
            }
            catch (NumberFormatException ignore) {
                // empty catch block
            }
        }
        req.setRewriteMimeType(MakeRequestHandler.getParameter(request, UriCommon.Param.REWRITE_MIME_TYPE.getKey(), null));
        AuthType auth = AuthType.parse(MakeRequestHandler.getParameter(request, AUTHZ_PARAM, null));
        req.setAuthType(auth);
        if (auth != AuthType.NONE) {
            req.setSecurityToken(this.extractAndValidateToken(request));
            if (auth == AuthType.OAUTH2) {
                req.setOAuth2Arguments(new OAuth2Arguments(request));
            } else {
                req.setOAuthArguments(new OAuthArguments(auth, request));
            }
        } else {
            req.setSecurityToken(token);
        }
        if (req.getHeader("User-Agent") == null && (userAgent = request.getHeader("User-Agent")) != null) {
            req.setHeader("User-Agent", userAgent);
        }
        ServletUtil.setXForwardedForHeader(request, req);
        return req;
    }

    protected void setPostData(String container, HttpServletRequest request, HttpRequest req) throws GadgetException {
        if (this.maxPostSizes.get(container) < request.getContentLength()) {
            throw new GadgetException(GadgetException.Code.POST_TOO_LARGE, "Posted data too large.", 413);
        }
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            String contentType = request.getHeader("Content-Type");
            if (contentType != null && contentType.startsWith("multipart/form-data")) {
                req.setPostBody((InputStream)request.getInputStream());
            } else {
                req.setPostBody(MakeRequestHandler.getParameter(request, POST_DATA_PARAM, "").getBytes(encoding.toUpperCase()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, e, 400);
        }
        catch (IOException e) {
            throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, e, 400);
        }
    }

    protected String convertResponseToJson(SecurityToken authToken, HttpServletRequest request, HttpResponse results) throws GadgetException {
        String updatedAuthToken;
        boolean getFullHeaders = Boolean.parseBoolean(MakeRequestHandler.getParameter(request, GET_FULL_HEADERS_PARAM, "false"));
        String originalUrl = MakeRequestHandler.getParameter(request, UriCommon.Param.URL.getKey(), null);
        String body = results.getResponseAsString();
        if (body.length() > 0 && "FEED".equals(MakeRequestHandler.getParameter(request, CONTENT_TYPE_PARAM, null))) {
            body = this.processFeed(originalUrl, request, body);
        }
        Map<String, Object> resp = FetchResponseUtils.getResponseAsJson(results, null, body, getFullHeaders);
        if (authToken != null && (updatedAuthToken = authToken.getUpdatedToken()) != null) {
            resp.put("st", updatedAuthToken);
        }
        return JsonSerializer.serialize(Collections.singletonMap(originalUrl, resp));
    }

    protected RequestPipeline getRequestPipeline() {
        return this.requestPipeline;
    }

    private SecurityToken extractAndValidateToken(HttpServletRequest request) throws GadgetException {
        SecurityToken token = AuthInfoUtil.getSecurityTokenFromRequest((HttpServletRequest)request);
        if (token == null) {
            throw new GadgetException(GadgetException.Code.INVALID_SECURITY_TOKEN);
        }
        return token;
    }

    private String processFeed(String url, HttpServletRequest req, String xml) throws GadgetException {
        int numEntries;
        boolean getSummaries = Boolean.parseBoolean(MakeRequestHandler.getParameter(req, GET_SUMMARIES_PARAM, "false"));
        try {
            numEntries = Integer.valueOf(MakeRequestHandler.getParameter(req, NUM_ENTRIES_PARAM, DEFAULT_NUM_ENTRIES));
        }
        catch (NumberFormatException e) {
            throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "numEntries paramater is not a number", 400);
        }
        return ((FeedProcessor)this.feedProcessorProvider.get()).process(url, xml, getSummaries, numEntries).toString();
    }

    protected static String getContainer(HttpServletRequest request) {
        String container = MakeRequestHandler.getParameter(request, UriCommon.Param.CONTAINER.getKey(), null);
        if (container == null) {
            container = MakeRequestHandler.getParameter(request, UriCommon.Param.SYND.getKey(), null);
        }
        return container != null ? container : "default";
    }

    protected static String getParameter(HttpServletRequest request, String key, String defaultValue) {
        String ret = request.getParameter(key);
        return ret != null ? ret : defaultValue;
    }

    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response, HttpResponse results) throws GadgetException {
        int refreshInterval = 0;
        if (results.isStrictNoCache() || "1".equals(MakeRequestHandler.getParameter(request, UriCommon.Param.NO_CACHE.getKey(), null))) {
            refreshInterval = 0;
        } else if (MakeRequestHandler.getParameter(request, UriCommon.Param.REFRESH.getKey(), null) != null) {
            try {
                refreshInterval = Integer.valueOf(MakeRequestHandler.getParameter(request, UriCommon.Param.REFRESH.getKey(), null));
            }
            catch (NumberFormatException nfe) {
                throw new GadgetException(GadgetException.Code.INVALID_PARAMETER, "refresh parameter is not a number", 400);
            }
        } else {
            refreshInterval = Math.max(3600, (int)(results.getCacheTtl() / 1000L));
        }
        HttpUtil.setCachingHeaders((HttpServletResponse)response, (int)refreshInterval, (boolean)false);
        if (!"1".equals(MakeRequestHandler.getParameter(request, MULTI_PART_FORM_POST, null))) {
            response.setHeader("Content-Disposition", "attachment;filename=p.txt");
        }
        if (response.getContentType() == null) {
            response.setContentType("application/octet-stream");
        }
    }

    public void containersChanged(ContainerConfig config, Collection<String> changed, Collection<String> removed) {
        for (String container : changed) {
            Map coreIO;
            Integer maxPostSize = config.getInt(container, MAX_POST_SIZE_KEY);
            if (maxPostSize == 0) {
                maxPostSize = 0x500000;
            }
            this.maxPostSizes.put(container, maxPostSize);
            Map features = config.getMap(container, GADGETS_FEATURES);
            if (features == null || (coreIO = (Map)features.get(CORE_IO)) == null) continue;
            this.unparseableCruftMsgs.put(container, (String)coreIO.get(UNPARSEABLE_CRUFT));
        }
        for (String container : removed) {
            this.maxPostSizes.remove(container);
            this.unparseableCruftMsgs.remove(container);
        }
    }
}

