/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.templates.NullTemplateLibrary;
import org.apache.shindig.gadgets.templates.TemplateLibrary;
import org.apache.shindig.gadgets.templates.XmlTemplateLibrary;

@Singleton
public class ContainerTagLibraryFactory {
    private static final Logger LOG = Logger.getLogger(ContainerTagLibraryFactory.class.getName());
    private final ContainerConfig config;
    private final LoadingCache<String, TemplateLibrary> osmlLibraryCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TemplateLibrary>(){

        public TemplateLibrary load(String resourceName) {
            return ContainerTagLibraryFactory.loadTrustedLibrary(resourceName);
        }
    });

    @Inject
    public ContainerTagLibraryFactory(ContainerConfig config) {
        this.config = config;
    }

    public TemplateLibrary getLibrary(String container) {
        return this.getOsmlLibrary(container);
    }

    private TemplateLibrary getOsmlLibrary(String container) {
        String library = this.config.getString(container, "${Cur['gadgets.features'].osml.library}");
        if (Strings.isNullOrEmpty((String)library)) {
            return NullTemplateLibrary.INSTANCE;
        }
        return (TemplateLibrary)this.osmlLibraryCache.getUnchecked((Object)library);
    }

    private static TemplateLibrary loadTrustedLibrary(String resource) {
        try {
            String content = ResourceLoader.getContent((String)resource);
            return new XmlTemplateLibrary(Uri.parse((String)"#OSML"), XmlUtil.parse((String)content), content, true);
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
        }
        catch (XmlException xe) {
            LOG.log(Level.WARNING, null, xe);
        }
        catch (GadgetException tpe) {
            LOG.log(Level.WARNING, null, tpe);
        }
        return NullTemplateLibrary.INSTANCE;
    }
}

