/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates.tags;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VarTagHandler
extends AbstractTagHandler {
    private static final String TAG_VAR = "Var";
    private static final String TAG_KEY = "key";
    private static final String TAG_VALUE = "value";

    @Inject
    public VarTagHandler() {
        super("http://ns.opensocial.org/2008/markup", TAG_VAR);
    }

    @Override
    public void process(Node result, Element tag, TemplateProcessor processor) {
        String key = tag.getAttribute(TAG_KEY);
        if ("".equals(key)) {
            return;
        }
        Object value = this.getValueFromTag(tag, TAG_VALUE, processor, Object.class);
        if (processor.getTemplateContext().getMy() == null) {
            processor.getTemplateContext().setMy(Maps.newHashMap());
        }
        processor.getTemplateContext().getMy().put(key, value);
    }
}

