/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.uri;

import com.google.caja.util.Maps;
import com.google.inject.ImplementedBy;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.LockedDomainService;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.DefaultJsUriManager;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;

public class DefaultIframeUriManager
implements IframeUriManager {
    private static final boolean DEFAULT_USE_TEMPLATES = false;
    static final String IFRAME_BASE_PATH_KEY = "gadgets.uri.iframe.basePath";
    static final String LOCKED_DOMAIN_REQUIRED_KEY = "gadgets.uri.iframe.lockedDomainRequired";
    public static final String LOCKED_DOMAIN_SUFFIX_KEY = "gadgets.uri.iframe.lockedDomainSuffix";
    public static final String UNLOCKED_DOMAIN_KEY = "gadgets.uri.iframe.unlockedDomain";
    public static final String SECURITY_TOKEN_ALWAYS_KEY = "gadgets.uri.iframe.alwaysAppendSecurityToken";
    public static final String LOCKED_DOMAIN_FEATURE_NAME = "locked-domain";
    public static final String SECURITY_TOKEN_FEATURE_NAME = "security-token";
    private TemplatingSignal tplSignal = null;
    private IframeUriManager.Versioner versioner = null;
    private Authority authority;
    private final ContainerConfig config;
    private final LockedDomainService ldService;
    private final SecurityTokenCodec securityTokenCodec;

    @Inject
    public DefaultIframeUriManager(ContainerConfig config, LockedDomainService ldService, SecurityTokenCodec securityTokenCodec) {
        this.config = config;
        this.ldService = ldService;
        this.securityTokenCodec = securityTokenCodec;
    }

    @Inject(optional=true)
    public void setVersioner(IframeUriManager.Versioner versioner) {
        this.versioner = versioner;
    }

    @Inject(optional=true)
    public void setTemplatingSignal(TemplatingSignal tplSignal) {
        this.tplSignal = tplSignal;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Override
    public Uri makeRenderingUri(Gadget gadget) {
        View view = gadget.getCurrentView();
        return this.buildUri(view, gadget);
    }

    protected Uri buildUri(View view, Gadget gadget) {
        GadgetContext context = gadget.getContext();
        String container = context.getContainer();
        UriBuilder uri = View.ContentType.URL.equals((Object)view.getType()) ? this.processUriForUrlTypeView(view, gadget) : this.processUriForHtmlTypeView(view, gadget);
        boolean useTpl = this.tplSignal != null ? this.tplSignal.useTemplates() : false;
        this.addDefaultUriParameters(uri, gadget, view, useTpl);
        this.addAllUserPrefs(uri, gadget, view, useTpl);
        if (this.versioner != null) {
            this.addParam(uri, UriCommon.Param.VERSION.getKey(), this.versioner.version(gadget.getSpec().getUrl(), container), false, false);
        }
        if (this.wantsSecurityToken(gadget)) {
            boolean securityTokenOnQuery = this.isTokenNeededForRendering(gadget);
            String securityToken = this.generateSecurityToken(gadget);
            this.addParam(uri, UriCommon.Param.SECURITY_TOKEN.getKey(), securityToken, securityToken == null, !securityTokenOnQuery);
        }
        this.addExtras(uri, gadget);
        return uri.toUri();
    }

    protected UriBuilder processUriForUrlTypeView(View view, Gadget gadget) {
        UriBuilder uri = new UriBuilder(view.getHref());
        String container = gadget.getContext().getContainer();
        this.addExtrasForTypeUrl(uri, gadget, container);
        return uri;
    }

    protected UriBuilder processUriForHtmlTypeView(View view, Gadget gadget) {
        String ldDomain;
        UriBuilder uri = new UriBuilder();
        GadgetContext context = gadget.getContext();
        String container = context.getContainer();
        uri.setPath(this.getReqVal(container, IFRAME_BASE_PATH_KEY));
        try {
            ldDomain = this.ldService.getLockedDomainForGadget(gadget, container);
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
        String host = "//" + (ldDomain == null ? this.getReqVal(container, UNLOCKED_DOMAIN_KEY) : ldDomain);
        Uri gadgetUri = Uri.parse((String)host);
        if (gadgetUri.getAuthority() == null && gadgetUri.getScheme() == null && gadgetUri.getPath().equals(host)) {
            gadgetUri = Uri.parse((String)("//" + host));
        }
        if (StringUtils.isBlank((CharSequence)gadgetUri.getScheme())) {
            uri.setScheme(this.getScheme(gadget, container));
        } else {
            uri.setScheme(gadgetUri.getScheme());
        }
        uri.setAuthority(gadgetUri.getAuthority());
        uri.addQueryParameter(UriCommon.Param.URL.getKey(), context.getUrl().toString());
        return uri;
    }

    protected void addDefaultUriParameters(UriBuilder uri, Gadget gadget, View view, boolean useTpl) {
        GadgetContext context = gadget.getContext();
        String container = context.getContainer();
        uri.addQueryParameter(UriCommon.Param.CONTAINER.getKey(), container);
        this.addParam(uri, UriCommon.Param.VIEW.getKey(), view.getName(), useTpl, false);
        this.addParam(uri, UriCommon.Param.LANG.getKey(), context.getLocale().getLanguage(), useTpl, false);
        this.addParam(uri, UriCommon.Param.COUNTRY.getKey(), context.getLocale().getCountry(), useTpl, false);
        this.addParam(uri, UriCommon.Param.DEBUG.getKey(), context.getDebug() ? "1" : "0", useTpl, false);
        this.addParam(uri, UriCommon.Param.NO_CACHE.getKey(), context.getIgnoreCache() ? "1" : "0", useTpl, false);
        this.addParam(uri, UriCommon.Param.SANITIZE.getKey(), context.getSanitize() ? "1" : "0", useTpl, false);
        if (context.getCajoled()) {
            this.addParam(uri, UriCommon.Param.CAJOLE.getKey(), "1", useTpl, false);
        }
    }

    protected void addAllUserPrefs(UriBuilder uri, Gadget gadget, View view, boolean useTpl) {
        GadgetContext context = gadget.getContext();
        UserPrefs prefs = context.getUserPrefs();
        for (UserPref up : gadget.getSpec().getUserPrefs().values()) {
            String name = up.getName();
            String data = prefs.getPref(name);
            if (data == null) {
                data = up.getDefaultValue();
            }
            boolean upInFragment = !view.needsUserPrefSubstitution();
            this.addParam(uri, "up_" + up.getName(), data, useTpl, upInFragment);
        }
    }

    protected String generateSecurityToken(Gadget gadget) {
        try {
            SecurityToken token = gadget.getContext().getToken();
            if (this.securityTokenCodec != null && token != null) {
                return this.securityTokenCodec.encodeToken(token);
            }
        }
        catch (SecurityTokenException securityTokenException) {
            // empty catch block
        }
        return null;
    }

    protected boolean wantsSecurityToken(Gadget gadget) {
        return gadget.getAllFeatures().contains(SECURITY_TOKEN_FEATURE_NAME) || this.config.getBool(gadget.getContext().getContainer(), SECURITY_TOKEN_ALWAYS_KEY);
    }

    protected boolean isTokenNeededForRendering(Gadget gadget) {
        return true;
    }

    @Override
    public UriStatus validateRenderingUri(Uri inUri) {
        Uri gadgetUri;
        UriBuilder uri = new UriBuilder(inUri);
        String gadgetStr = uri.getQueryParameter(UriCommon.Param.URL.getKey());
        try {
            gadgetUri = Uri.parse((String)gadgetStr);
        }
        catch (Exception e) {
            return UriStatus.BAD_URI;
        }
        String container = uri.getQueryParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = "default";
        }
        String version = uri.getQueryParameter(UriCommon.Param.VERSION.getKey());
        if (this.versioner == null || version == null) {
            return UriStatus.VALID_UNVERSIONED;
        }
        return this.versioner.validate(gadgetUri, container, version);
    }

    public static String tplKey(String key) {
        return '%' + key + '%';
    }

    protected String getScheme(Gadget gadget, String container) {
        return null;
    }

    protected void addExtrasForTypeUrl(UriBuilder uri, Gadget gadget, String container) {
        Set<String> features = gadget.getViewFeatures().keySet();
        String jsHost = this.getReqVal(container, "gadgets.uri.js.host");
        String jsPathBase = this.getReqVal(container, "gadgets.uri.js.path");
        UriBuilder jsuri = null;
        if (features.size() > 0) {
            jsuri = new UriBuilder(Uri.parse((String)jsHost));
            StringBuilder builder = new StringBuilder(jsPathBase);
            if (!jsPathBase.endsWith("/")) {
                builder.append('/');
            }
            builder.append(DefaultJsUriManager.addJsLibs(features));
            builder.append(".js");
            jsuri.setPath(builder.toString());
        }
        this.addParam(uri, UriCommon.Param.LIBS.getKey(), jsuri == null ? "" : jsuri.toString(), false, false);
    }

    protected void addExtras(UriBuilder uri, Gadget gadget) {
    }

    private void addParam(UriBuilder uri, String key, String data, boolean templated, boolean fragment) {
        String value = templated ? DefaultIframeUriManager.tplKey(key) : data;
        if (!fragment) {
            uri.addQueryParameter(key, value);
        } else {
            uri.addFragmentParameter(key, value);
        }
    }

    private String getReqVal(String container, String key) {
        String val = this.config.getString(container, key);
        if (val == null) {
            throw new RuntimeException("Missing required container config param, key: " + key + ", container: " + container);
        }
        if (this.authority != null) {
            val = val.replace("%authority%", this.authority.getAuthority());
        }
        return val;
    }

    @Override
    public Map<String, Uri> makeAllRenderingUris(Gadget gadget) {
        Map uris = Maps.newHashMap();
        Map<String, View> views = gadget.getSpec().getViews();
        for (String key : views.keySet()) {
            View view = views.get(key);
            uris.put(key, this.buildUri(view, gadget));
        }
        return uris;
    }

    public static final class DefaultTemplatingSignal
    implements TemplatingSignal {
        private boolean useTemplates = true;

        @Inject(optional=true)
        public void setUseTemplates(@Named(value="shindig.urlgen.use-templates-default") Boolean useTemplates) {
            this.useTemplates = useTemplates;
        }

        @Override
        public boolean useTemplates() {
            return this.useTemplates;
        }
    }

    @ImplementedBy(value=DefaultTemplatingSignal.class)
    public static interface TemplatingSignal {
        public boolean useTemplates();
    }
}

