/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.spec.GadgetSpec;

public class FakeGadgetSpecFactory
implements GadgetSpecFactory {
    public static final String SERVICE_NAME = "testservice";
    public static final String SERVICE_NAME_NO_KEY = "nokey";

    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        Uri uri = context.getUrl();
        String gadget = uri.toString();
        String baseSpec = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n  <Module>\n    <ModulePrefs title=\"hello world example\">\n   \n    <OAuth>\n      <Service name='testservice'>        <Access           url='http://www.example.com/access'          param_location='uri-query'           method='GET'        />        <Request           url='http://www.example.com/request?param=foo'          param_location='uri-query'           method='GET'        />        <Authorization           url='http://www.example.com/authorize'        />      </Service>    </OAuth>\n    </ModulePrefs>\n    <Content type=\"html\">\n       <![CDATA[\n         Hello, world!\n       ]]>\n       \n    </Content>\n  </Module>";
        if (gadget.contains(SERVICE_NAME_NO_KEY)) {
            String nokeySpec = baseSpec.replace(SERVICE_NAME, SERVICE_NAME_NO_KEY);
            return new GadgetSpec(uri, nokeySpec);
        }
        if (gadget.contains("header")) {
            String headerSpec = baseSpec.replace("uri-query", "auth-header");
            return new GadgetSpec(uri, headerSpec);
        }
        if (gadget.contains("body")) {
            String bodySpec = baseSpec.replace("uri-query", "post-body");
            bodySpec = bodySpec.replace("'GET'", "'POST'");
            return new GadgetSpec(uri, bodySpec);
        }
        if (gadget.contains("badoauthurl")) {
            String spec = baseSpec.replace("/request?param=foo", "/echo?mary_had_a_little_lamb");
            spec = spec.replace("/access", "/echo?add_oauth_token=with_fleece_as_white_as_snow");
            spec = spec.replace("uri-query", "auth-header");
            return new GadgetSpec(uri, spec);
        }
        if (gadget.contains("approvalparams")) {
            String spec = baseSpec.replace("/authorize", "/authorize?oauth_callback=foo");
            return new GadgetSpec(uri, spec);
        }
        return new GadgetSpec(uri, baseSpec);
    }
}

