/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.regex.Pattern;
import org.apache.shindig.common.util.HashUtil;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class DefaultUrlGenerator
implements UrlGenerator {
    private static final Pattern ALLOWED_FEATURE_NAME = Pattern.compile("[0-9a-zA-Z\\.\\-]+");
    private final String jsPrefix;
    private final String iframePrefix;
    private final String jsChecksum;

    @Inject
    public DefaultUrlGenerator(@Named(value="shindig.urls.iframe.prefix") String iframePrefix, @Named(value="shindig.urls.js.prefix") String jsPrefix, GadgetFeatureRegistry registry) {
        this.iframePrefix = iframePrefix;
        this.jsPrefix = jsPrefix;
        StringBuilder jsBuf = new StringBuilder();
        for (GadgetFeature feature : registry.getAllFeatures()) {
            for (JsLibrary library : feature.getJsLibraries(null, null)) {
                jsBuf.append(library.getContent());
            }
        }
        this.jsChecksum = HashUtil.checksum((byte[])jsBuf.toString().getBytes());
    }

    @Override
    public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
        return this.jsPrefix + this.getBundledJsParam(features, context);
    }

    @Override
    public String getBundledJsParam(Collection<String> features, GadgetContext context) {
        StringBuilder buf = new StringBuilder();
        boolean first = false;
        for (String feature : features) {
            if (!ALLOWED_FEATURE_NAME.matcher(feature).matches()) continue;
            if (!first) {
                first = true;
            } else {
                buf.append(':');
            }
            buf.append(feature);
        }
        if (!first) {
            buf.append("core");
        }
        buf.append(".js?v=").append(this.jsChecksum).append("&container=").append(context.getContainer()).append("&debug=").append(context.getDebug() ? "1" : "0");
        return buf.toString();
    }

    @Override
    public String getIframeUrl(Gadget gadget) {
        StringBuilder buf = new StringBuilder();
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        String url = context.getUrl().toString();
        View view = gadget.getCurrentView();
        View.ContentType type = view == null ? View.ContentType.HTML : view.getType();
        switch (type) {
            case URL: {
                String href = view.getHref().toString();
                buf.append(href);
                if (href.indexOf(63) == -1) {
                    buf.append('?');
                    break;
                }
                buf.append('&');
                break;
            }
            default: {
                buf.append(this.iframePrefix);
            }
        }
        buf.append("container=").append(context.getContainer());
        if (context.getModuleId() != 0) {
            buf.append("&mid=").append(context.getModuleId());
        }
        if (context.getIgnoreCache()) {
            buf.append("&nocache=1");
        } else {
            buf.append("&v=").append(spec.getChecksum());
        }
        buf.append("&lang=").append(context.getLocale().getLanguage());
        buf.append("&country=").append(context.getLocale().getCountry());
        buf.append("&view=").append(context.getView());
        UserPrefs prefs = context.getUserPrefs();
        for (UserPref pref : gadget.getSpec().getUserPrefs()) {
            String name = pref.getName();
            String value = prefs.getPref(name);
            if (value == null) {
                value = pref.getDefaultValue();
            }
            buf.append("&up_").append(Utf8UrlCoder.encode((String)pref.getName())).append('=').append(Utf8UrlCoder.encode((String)value));
        }
        if (!type.equals((Object)View.ContentType.URL)) {
            buf.append("&url=").append(Utf8UrlCoder.encode((String)url));
        }
        return buf.toString();
    }
}

