/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.rewrite.MutableContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContentRewriterRegistry
implements ContentRewriterRegistry {
    protected final List<ContentRewriter> rewriters;
    protected final GadgetHtmlParser htmlParser;

    @Inject
    public DefaultContentRewriterRegistry(List<ContentRewriter> rewriters, GadgetHtmlParser htmlParser) {
        if (rewriters == null) {
            rewriters = Collections.emptyList();
        }
        this.rewriters = new LinkedList<ContentRewriter>(rewriters);
        this.htmlParser = htmlParser;
    }

    @Override
    public String rewriteGadget(Gadget gadget, String content) {
        if (content == null) {
            return null;
        }
        MutableContent mc = this.getMutableContent(content);
        for (ContentRewriter rewriter : this.rewriters) {
            mc.getContent();
            rewriter.rewrite(gadget, mc);
        }
        return mc.getContent();
    }

    @Override
    public HttpResponse rewriteHttpResponse(HttpRequest req, HttpResponse resp) {
        String originalContent = resp.getResponseAsString();
        MutableContent mc = this.getMutableContent(originalContent);
        for (ContentRewriter rewriter : this.rewriters) {
            rewriter.rewrite(req, resp, mc);
        }
        String rewrittenContent = mc.getContent();
        if (rewrittenContent.equals(originalContent)) {
            return resp;
        }
        return new HttpResponseBuilder(resp).setResponseString(rewrittenContent).create();
    }

    protected MutableContent getMutableContent(String content) {
        MutableContent mc = new MutableContent(this.htmlParser);
        mc.setContent(content);
        return mc;
    }

    protected List<ContentRewriter> getRewriters() {
        return this.rewriters;
    }
}

