/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import junit.framework.TestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.BasicGadgetBlacklist;
import org.apache.shindig.gadgets.GadgetBlacklist;

public class BasicGadgetBlacklistTest
extends TestCase {
    private Uri someUri;

    protected void setUp() throws Exception {
        super.setUp();
        this.someUri = Uri.parse((String)"http://bla.com/foo.xml");
    }

    private GadgetBlacklist createBlacklist(String contents) throws IOException {
        File temp = File.createTempFile("blacklist_test", ".txt");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(contents);
        out.close();
        return new BasicGadgetBlacklist(temp);
    }

    public void testEmptyBlacklist() throws Exception {
        GadgetBlacklist bl = this.createBlacklist("");
        BasicGadgetBlacklistTest.assertFalse((boolean)bl.isBlacklisted(this.someUri));
    }

    public void testExactMatches() throws Exception {
        GadgetBlacklist bl = this.createBlacklist(this.someUri + "\nhttp://baz.com/foo.xml");
        BasicGadgetBlacklistTest.assertFalse((boolean)bl.isBlacklisted(Uri.parse((String)"http://random.com/uri.xml")));
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(this.someUri));
    }

    public void testExactMatchesWithCaseMixture() throws Exception {
        GadgetBlacklist bl = this.createBlacklist(this.someUri + "\nhttp://BAZ.com/foo.xml");
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(this.someUri));
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(Uri.parse((String)"http://BLA.com/foo.xml")));
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(Uri.parse((String)"http://baz.com/foo.xml")));
    }

    public void testIgnoredCommentsAndWhitespace() throws Exception {
        GadgetBlacklist bl = this.createBlacklist("# comment\n  \t" + this.someUri + " \n  # comment\n\n");
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(this.someUri));
    }

    public void testRegexpMatches() throws Exception {
        GadgetBlacklist bl = this.createBlacklist("REGEXP http://bla.com/.*");
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(this.someUri));
        BasicGadgetBlacklistTest.assertTrue((boolean)bl.isBlacklisted(Uri.parse((String)"http://bla.com/bar.xml")));
        BasicGadgetBlacklistTest.assertFalse((boolean)bl.isBlacklisted(Uri.parse((String)"http://blo.com/bar.xml")));
    }

    public void testInvalidRegularExpression() throws Exception {
        try {
            this.createBlacklist("REGEXP +http://bla.com/.*");
            BasicGadgetBlacklistTest.fail();
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }
}

