/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.Map;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.junit.Test;

public class FetchResponseUtilsTest {
    @Test
    public void testSimpleResponse() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).create();
        Map obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"key", (String)"body");
        JsonAssert.assertObjectEquals((Object)"{'rc':999,'id':'key',body:'body'}", (Object)obj);
    }

    @Test
    public void testMetadata() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).setMetadata("metaname", "metavalue").setMetadata("more meta", "more value").create();
        Map obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, null, (String)"body");
        JsonAssert.assertObjectEquals((Object)"{rc:999,body:'body',metaname:'metavalue','more meta':'more value'}", (Object)obj);
    }

    @Test
    public void testHeaders() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).setHeader("Set-Cookie", "cookie").setHeader("location", "here").create();
        Map obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"key", (String)"body");
        JsonAssert.assertObjectEquals((Object)"{rc:999,id:'key',body:'body',headers:{set-cookie:['cookie'],location:['here']}}", (Object)obj);
    }

    @Test
    public void testMultiValuedHeaders() throws Exception {
        HttpResponse response = new HttpResponseBuilder().setHttpStatusCode(999).addHeader("Set-Cookie", "cookie").addHeader("Set-Cookie", "cookie2").addHeader("Set-Cookie", "cookie3").create();
        Map obj = FetchResponseUtils.getResponseAsJson((HttpResponse)response, (String)"key", (String)"body");
        JsonAssert.assertObjectEquals((Object)"{rc:999,id:'key',body:'body',headers:{set-cookie:['cookie','cookie2','cookie3']}}", (Object)obj);
    }
}

