/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.LruCacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.DefaultHttpCache;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.junit.Assert;
import org.junit.Test;

public class DefaultHttpCacheTest {
    private static final Uri DEFAULT_URI = Uri.parse((String)"http://example.org/file.txt");
    private final CacheProvider cacheProvider = new LruCacheProvider(10);
    private final Cache<String, HttpResponse> cache = this.cacheProvider.createCache("httpResponses");
    private final DefaultHttpCache httpCache = new DefaultHttpCache(this.cacheProvider);

    @Test
    public void getResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponse("response");
        String key = this.httpCache.createKey(request);
        this.cache.addElement((Object)key, (Object)response);
        Assert.assertEquals((Object)response, (Object)this.httpCache.getResponse(request));
    }

    @Test
    public void addResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponse("response");
        this.httpCache.addResponse(request, response);
        String key = this.httpCache.createKey(request);
        Assert.assertEquals((Object)response, (Object)this.cache.getElement((Object)key));
    }

    @Test
    public void removeResponse() {
        HttpRequest request = new HttpRequest(DEFAULT_URI);
        HttpResponse response = new HttpResponse("response");
        String key = this.httpCache.createKey(request);
        this.cache.addElement((Object)key, (Object)response);
        Assert.assertEquals((Object)response, (Object)this.httpCache.removeResponse(request));
        Assert.assertEquals((long)0L, (long)this.cache.getSize());
    }
}

