/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.Maps;
import com.google.inject.Provider;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.DefaultRequestPipeline;
import org.apache.shindig.gadgets.http.HttpCache;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.http.InvalidationService;
import org.apache.shindig.gadgets.http.NoOpInvalidationService;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.oauth.OAuthRequest;
import org.apache.shindig.gadgets.rewrite.image.ImageRewriter;
import org.apache.shindig.gadgets.rewrite.image.NoOpImageRewriter;
import org.junit.Assert;
import org.junit.Test;

public class DefaultRequestPipelineTest {
    private static final Uri DEFAULT_URI = Uri.parse((String)"http://example.org/gadget.xml");
    private final FakeHttpFetcher fetcher = new FakeHttpFetcher();
    private final FakeHttpCache cache = new FakeHttpCache();
    private final FakeOAuthRequestProvider oauth = new FakeOAuthRequestProvider();
    private final RequestPipeline pipeline = new DefaultRequestPipeline((HttpFetcher)this.fetcher, (HttpCache)this.cache, (Provider)this.oauth, (ImageRewriter)new NoOpImageRewriter(), (InvalidationService)new NoOpInvalidationService());

    @Test
    public void authTypeNoneNotCached() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.NONE);
        this.fetcher.response = new HttpResponse("response");
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)request, (Object)this.fetcher.request);
        Assert.assertEquals((Object)this.fetcher.response, (Object)response);
        Assert.assertEquals((Object)response, (Object)this.cache.data.get(DEFAULT_URI));
        Assert.assertEquals((long)1L, (long)this.cache.readCount);
        Assert.assertEquals((long)1L, (long)this.cache.writeCount);
        Assert.assertEquals((long)1L, (long)this.fetcher.fetchCount);
    }

    @Test
    public void authTypeNoneWasCached() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.NONE);
        HttpResponse cached = new HttpResponse("cached");
        this.cache.data.put(DEFAULT_URI, cached);
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)cached, (Object)response);
        Assert.assertEquals((long)1L, (long)this.cache.readCount);
        Assert.assertEquals((long)0L, (long)this.cache.writeCount);
        Assert.assertEquals((long)0L, (long)this.fetcher.fetchCount);
    }

    @Test
    public void authTypeNoneWasCachedButStale() throws Exception {
        HttpResponse fetched;
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.NONE);
        HttpResponse cached = new HttpResponseBuilder().setStrictNoCache().create();
        this.cache.data.put(DEFAULT_URI, cached);
        this.fetcher.response = fetched = new HttpResponse("fetched");
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)fetched, (Object)response);
        Assert.assertEquals((Object)request, (Object)this.fetcher.request);
        Assert.assertEquals((Object)fetched, (Object)this.cache.data.get(DEFAULT_URI));
        Assert.assertEquals((long)1L, (long)this.cache.readCount);
        Assert.assertEquals((long)1L, (long)this.cache.writeCount);
        Assert.assertEquals((long)1L, (long)this.fetcher.fetchCount);
    }

    @Test
    public void authTypeNoneIgnoreCache() throws Exception {
        HttpResponse fetched;
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.NONE).setIgnoreCache(true);
        this.fetcher.response = fetched = new HttpResponse("fetched");
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)fetched, (Object)response);
        Assert.assertEquals((Object)request, (Object)this.fetcher.request);
        Assert.assertEquals((long)0L, (long)this.cache.readCount);
        Assert.assertEquals((long)0L, (long)this.cache.writeCount);
        Assert.assertEquals((long)1L, (long)this.fetcher.fetchCount);
    }

    @Test
    public void authTypeOAuthNotCached() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.OAUTH);
        this.oauth.httpResponse = new HttpResponse("oauth result");
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)this.oauth.httpResponse, (Object)response);
        Assert.assertEquals((Object)request, (Object)this.oauth.httpRequest);
        Assert.assertEquals((Object)response, (Object)this.cache.data.get(DEFAULT_URI));
        Assert.assertEquals((long)1L, (long)this.oauth.fetchCount);
        Assert.assertEquals((long)0L, (long)this.fetcher.fetchCount);
        Assert.assertEquals((long)1L, (long)this.cache.readCount);
        Assert.assertEquals((long)1L, (long)this.cache.writeCount);
    }

    @Test
    public void authTypeOAuthWasCached() throws Exception {
        HttpRequest request = new HttpRequest(DEFAULT_URI).setAuthType(AuthType.OAUTH);
        HttpResponse cached = new HttpResponse("cached");
        this.cache.data.put(DEFAULT_URI, cached);
        HttpResponse response = this.pipeline.execute(request);
        Assert.assertEquals((Object)cached, (Object)response);
        Assert.assertEquals((long)0L, (long)this.oauth.fetchCount);
        Assert.assertEquals((long)0L, (long)this.fetcher.fetchCount);
        Assert.assertEquals((long)1L, (long)this.cache.readCount);
        Assert.assertEquals((long)0L, (long)this.cache.writeCount);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FakeOAuthRequestProvider
    implements Provider<OAuthRequest> {
        protected int fetchCount = 0;
        protected HttpRequest httpRequest;
        protected HttpResponse httpResponse;
        private final OAuthRequest oauthRequest = new OAuthRequest(null, null){

            public HttpResponse fetch(HttpRequest request) {
                ++FakeOAuthRequestProvider.this.fetchCount;
                FakeOAuthRequestProvider.this.httpRequest = request;
                return FakeOAuthRequestProvider.this.httpResponse;
            }
        };

        protected FakeOAuthRequestProvider() {
        }

        public OAuthRequest get() {
            return this.oauthRequest;
        }
    }

    public static class FakeHttpCache
    implements HttpCache {
        protected final Map<Uri, HttpResponse> data = Maps.newHashMap();
        protected int writeCount = 0;
        protected int readCount = 0;

        protected FakeHttpCache() {
        }

        public boolean addResponse(HttpRequest request, HttpResponse response) {
            ++this.writeCount;
            this.data.put(request.getUri(), response);
            return true;
        }

        public HttpResponse getResponse(HttpRequest request) {
            ++this.readCount;
            return this.data.get(request.getUri());
        }

        public HttpResponse removeResponse(HttpRequest key) {
            throw new UnsupportedOperationException();
        }

        public String createKey(HttpRequest request) {
            return request.getUri().getQuery();
        }
    }

    public static class FakeHttpFetcher
    implements HttpFetcher {
        protected HttpRequest request;
        protected HttpResponse response;
        protected int fetchCount = 0;

        protected FakeHttpFetcher() {
        }

        public HttpResponse fetch(HttpRequest request) throws GadgetException {
            ++this.fetchCount;
            this.request = request;
            if (this.response == null) {
                throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT);
            }
            return this.response;
        }
    }
}

