/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.parser.css.CssTree;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;

public class CajaCssSanitizerTest
extends EasyMockTestCase {
    private CajaCssParser parser;
    private CajaCssSanitizer sanitizer;
    private final Uri DUMMY = Uri.parse((String)"http://www.example.org/base");
    private LinkRewriter importRewriter;
    private LinkRewriter imageRewriter;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new CajaCssParser();
        this.sanitizer = new CajaCssSanitizer(this.parser);
        this.importRewriter = new LinkRewriter(){

            public String rewrite(String link, Uri context) {
                return link + "&" + "sanitize" + "=1&rewriteMime=text/css";
            }
        };
        this.imageRewriter = new LinkRewriter(){

            public String rewrite(String link, Uri context) {
                return link + "&" + "sanitize" + "=1&rewriteMime=image/*";
            }
        };
    }

    public void testPreserveSafe() throws Exception {
        String css = ".xyz { font: bold;} A { color: #7f7f7f}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.importRewriter, this.imageRewriter);
        this.assertStyleEquals(css, styleSheet);
    }

    public void testSanitizeFunctionCall() throws Exception {
        String css = ".xyz { font : iamevil(bold); }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.importRewriter, this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    public void testSanitizeUnsafeProperties() throws Exception {
        String css = ".xyz { behavior: url('xyz.htc'); -moz-binding:url(\"http://ha.ckers.org/xssmoz.xml#xss\") }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.importRewriter, this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    public void testSanitizeScriptUrls() throws Exception {
        String css = ".xyz { background: url('javascript:doevill'); background : url(vbscript:moreevil); }";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.importRewriter, this.imageRewriter);
        this.assertStyleEquals(".xyz {}", styleSheet);
    }

    public void testProxyUrls() throws Exception {
        String css = ".xyz { background: url('http://www.example.org/img.gif');}";
        CssTree.StyleSheet styleSheet = this.parser.parseDom(css);
        this.sanitizer.sanitize((CssTree)styleSheet, this.DUMMY, this.importRewriter, this.imageRewriter);
        this.assertStyleEquals(".xyz { background: url('http://www.example.org/img.gif\\26sanitize%3d1\\26rewriteMime%3dimage/\\2A ');}", styleSheet);
    }

    public void assertStyleEquals(String expected, CssTree.StyleSheet styleSheet) throws Exception {
        CajaCssSanitizerTest.assertEquals((String)this.parser.serialize(this.parser.parseDom(expected)), (String)this.parser.serialize(styleSheet));
    }
}

