/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.preload;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import org.apache.shindig.common.JsonAssert;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.preload.ConcurrentPreloaderService;
import org.apache.shindig.gadgets.preload.PipelineExecutor;
import org.apache.shindig.gadgets.preload.PipelinedDataPreloader;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.preload.PreloaderService;
import org.apache.shindig.gadgets.spec.PipelinedData;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.easymock.Capture;
import org.easymock.IArgumentMatcher;
import org.easymock.classextension.EasyMock;
import org.easymock.classextension.IMocksControl;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipelineExecutorTest {
    private IMocksControl control;
    private PipelinedDataPreloader preloader;
    private PreloaderService preloaderService;
    private GadgetContext context;
    private PipelineExecutor executor;
    private static final Uri GADGET_URI = Uri.parse((String)"http://example.org/gadget.php");
    private static final String CONTENT = "<Content xmlns:os=\"http://ns.opensocial.org/2008/markup\">  <os:PeopleRequest key=\"me\" userId=\"canonical\"/>  <os:HttpRequest key=\"json\" href=\"test.json\"/></Content>";
    private static final String TWO_BATCH_CONTENT = "<Content xmlns:os=\"http://ns.opensocial.org/2008/markup\">  <os:PeopleRequest key=\"me\" userId=\"${json.user}\"/>  <os:HttpRequest key=\"json\" href=\"${ViewParams.file}\"/></Content>";
    private static final String BLOCKED_FIRST_BATCH_CONTENT = "<Content xmlns:os=\"http://ns.opensocial.org/2008/markup\">  <os:PeopleRequest key=\"me\" userId=\"${json.user}\"/></Content>";

    @Before
    public void setUp() throws Exception {
        this.control = EasyMock.createStrictControl();
        this.preloader = (PipelinedDataPreloader)this.control.createMock(PipelinedDataPreloader.class);
        this.preloaderService = new ConcurrentPreloaderService(Executors.newSingleThreadExecutor(), null);
        this.executor = new PipelineExecutor(this.preloader, this.preloaderService, Expressions.forTesting());
        this.context = new GadgetContext(){};
    }

    private PipelinedData getPipelinedData(String pipelineXml) throws SpecParserException {
        Element element = XmlUtil.parseSilent((String)pipelineXml);
        return new PipelinedData(element, GADGET_URI);
    }

    @Test
    public void execute() throws Exception {
        PipelinedData pipeline = this.getPipelinedData(CONTENT);
        Capture batchCapture = new Capture();
        JSONObject expectedData = new JSONObject("{data: {foo: 'bar'}}");
        Callable<PreloadedData> callable = this.createPreloadTask("key", expectedData.toString());
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), (PipelinedData.Batch)org.easymock.EasyMock.and((Object)this.eqBatch(1, 1), (Object)org.easymock.EasyMock.capture((Capture)batchCapture)))).andReturn((Object)ImmutableList.of(callable));
        this.control.replay();
        PipelineExecutor.Results results = this.executor.execute(this.context, (Collection)ImmutableList.of((Object)pipeline));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getSocialPreloads().containsKey("me"));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getHttpPreloads().containsKey("json"));
        JsonAssert.assertJsonEquals((String)"[{id: 'key', data: {foo: 'bar'}}]", (String)JsonSerializer.serialize((Collection)results.results));
        JsonAssert.assertJsonEquals((String)"{foo: 'bar'}", (String)JsonSerializer.serialize(results.keyedResults.get("key")));
        Assert.assertTrue((boolean)results.remainingPipelines.isEmpty());
        this.control.verify();
    }

    @Test
    public void executeWithTwoBatches() throws Exception {
        PipelinedData pipeline = this.getPipelinedData(TWO_BATCH_CONTENT);
        this.context = new GadgetContext(){

            public String getParameter(String property) {
                if ("view-params".equals(property)) {
                    return "{'file': 'test.json'}";
                }
                return null;
            }
        };
        Capture firstBatch = new Capture();
        Callable<PreloadedData> firstTask = this.createPreloadTask("json", "{data: {user: 'canonical'}}");
        Capture secondBatch = new Capture();
        Callable<PreloadedData> secondTask = this.createPreloadTask("me", "{data: {'id':'canonical'}}");
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), (PipelinedData.Batch)org.easymock.EasyMock.and((Object)this.eqBatch(0, 1), (Object)org.easymock.EasyMock.capture((Capture)firstBatch)))).andReturn((Object)ImmutableList.of(firstTask));
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), (PipelinedData.Batch)org.easymock.EasyMock.and((Object)this.eqBatch(1, 0), (Object)org.easymock.EasyMock.capture((Capture)secondBatch)))).andReturn((Object)ImmutableList.of(secondTask));
        this.control.replay();
        PipelineExecutor.Results results = this.executor.execute(this.context, (Collection)ImmutableList.of((Object)pipeline));
        JsonAssert.assertJsonEquals((String)"[{id: 'json', data: {user: 'canonical'}},{id: 'me', data: {id: 'canonical'}}]", (String)JsonSerializer.serialize((Collection)results.results));
        Assert.assertEquals((Object)ImmutableSet.of((Object[])new String[]{"json", "me"}), results.keyedResults.keySet());
        Assert.assertTrue((boolean)results.remainingPipelines.isEmpty());
        this.control.verify();
        RequestAuthenticationInfo request = (RequestAuthenticationInfo)((PipelinedData.Batch)firstBatch.getValue()).getHttpPreloads().get("json");
        Assert.assertEquals((Object)"http://example.org/test.json", (Object)request.getHref().toString());
        JSONObject personRequest = (JSONObject)((PipelinedData.Batch)secondBatch.getValue()).getSocialPreloads().get("me");
        Assert.assertEquals((Object)"canonical", (Object)personRequest.getJSONObject("params").getJSONArray("userId").get(0));
    }

    @Test
    public void executeWithBlockedBatch() throws Exception {
        PipelinedData pipeline = this.getPipelinedData(BLOCKED_FIRST_BATCH_CONTENT);
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), this.eqBatch(0, 0))).andReturn((Object)ImmutableList.of());
        this.control.replay();
        PipelineExecutor.Results results = this.executor.execute(this.context, (Collection)ImmutableList.of((Object)pipeline));
        Assert.assertEquals((long)0L, (long)results.results.size());
        Assert.assertTrue((boolean)results.keyedResults.isEmpty());
        Assert.assertEquals((long)1L, (long)results.remainingPipelines.size());
        Assert.assertSame((Object)pipeline, results.remainingPipelines.iterator().next());
        this.control.verify();
    }

    @Test
    public void executeError() throws Exception {
        PipelinedData pipeline = this.getPipelinedData(CONTENT);
        Capture batchCapture = new Capture();
        JSONObject expectedData = new JSONObject("{error: {message: 'NO!', code: 500}}");
        Callable<PreloadedData> callable = this.createPreloadTask("key", expectedData.toString());
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), (PipelinedData.Batch)org.easymock.EasyMock.and((Object)this.eqBatch(1, 1), (Object)org.easymock.EasyMock.capture((Capture)batchCapture)))).andReturn((Object)ImmutableList.of(callable));
        this.control.replay();
        PipelineExecutor.Results results = this.executor.execute(this.context, (Collection)ImmutableList.of((Object)pipeline));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getSocialPreloads().containsKey("me"));
        Assert.assertTrue((boolean)((PipelinedData.Batch)batchCapture.getValue()).getHttpPreloads().containsKey("json"));
        JsonAssert.assertJsonEquals((String)"[{id: 'key', error: {message: 'NO!', code: 500}}]", (String)JsonSerializer.serialize((Collection)results.results));
        JsonAssert.assertJsonEquals((String)"{message: 'NO!', code: 500}", (String)JsonSerializer.serialize(results.keyedResults.get("key")));
        Assert.assertTrue((boolean)results.remainingPipelines.isEmpty());
        this.control.verify();
    }

    @Test
    public void executePreloadException() throws Exception {
        PipelinedData pipeline = this.getPipelinedData(CONTENT);
        final PreloadedData willThrow = (PreloadedData)this.control.createMock(PreloadedData.class);
        Callable<PreloadedData> callable = new Callable<PreloadedData>(){

            @Override
            public PreloadedData call() throws Exception {
                return willThrow;
            }
        };
        org.easymock.EasyMock.expect((Object)this.preloader.createPreloadTasks((GadgetContext)org.easymock.EasyMock.same((Object)this.context), (PipelinedData.Batch)org.easymock.EasyMock.isA(PipelinedData.Batch.class))).andReturn((Object)ImmutableList.of((Object)callable));
        org.easymock.EasyMock.expect((Object)willThrow.toJson()).andThrow((Throwable)new PreloadException("Failed"));
        this.control.replay();
        PipelineExecutor.Results results = this.executor.execute(this.context, (Collection)ImmutableList.of((Object)pipeline));
        Assert.assertEquals((long)0L, (long)results.results.size());
        Assert.assertTrue((boolean)results.keyedResults.isEmpty());
        Assert.assertTrue((boolean)results.remainingPipelines.isEmpty());
        this.control.verify();
    }

    private PipelinedData.Batch eqBatch(int socialCount, int httpCount) {
        org.easymock.EasyMock.reportMatcher((IArgumentMatcher)new BatchMatcher(socialCount, httpCount));
        return null;
    }

    private Callable<PreloadedData> createPreloadTask(String key, String jsonResult) throws JSONException {
        final JSONObject value = new JSONObject(jsonResult);
        value.put("id", (Object)key);
        final PreloadedData preloadResult = new PreloadedData(){

            public Collection<Object> toJson() throws PreloadException {
                return ImmutableList.of((Object)value);
            }
        };
        Callable<PreloadedData> callable = new Callable<PreloadedData>(){

            @Override
            public PreloadedData call() throws Exception {
                return preloadResult;
            }
        };
        return callable;
    }

    private static class BatchMatcher
    implements IArgumentMatcher {
        private final int socialCount;
        private final int httpCount;

        public BatchMatcher(int socialCount, int httpCount) {
            this.socialCount = socialCount;
            this.httpCount = httpCount;
        }

        public void appendTo(StringBuffer buffer) {
            buffer.append("eqBuffer[social=" + this.socialCount + ",http=" + this.httpCount + "]");
        }

        public boolean matches(Object obj) {
            if (!(obj instanceof PipelinedData.Batch)) {
                return false;
            }
            PipelinedData.Batch batch = (PipelinedData.Batch)obj;
            return this.socialCount == batch.getSocialPreloads().size() && this.httpCount == batch.getHttpPreloads().size();
        }
    }
}

