/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.shindig.gadgets.render.OpenSocialI18NGadgetRewriter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpenSocialI18NGadgetRewriterTest {
    private OpenSocialI18NGadgetRewriter i18nRewriter;
    private Locale localeAtRendering;

    @Before
    public void setUp() throws Exception {
        this.i18nRewriter = new FakeOpenSocialI18NGadgetRewriter();
    }

    @Test
    public void localeNameForEnglish() throws Exception {
        this.localeAtRendering = new Locale("en");
        Assert.assertEquals((Object)"en", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForEnglishUS() throws Exception {
        this.localeAtRendering = new Locale("en", "US");
        Assert.assertEquals((Object)"en_US", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForChinese() throws Exception {
        this.localeAtRendering = new Locale("zh");
        Assert.assertEquals((Object)"zh", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForChineseCN() throws Exception {
        this.localeAtRendering = new Locale("zh", "CN");
        Assert.assertEquals((Object)"zh_CN", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForChineseAll() throws Exception {
        this.localeAtRendering = new Locale("zh", "All");
        Assert.assertEquals((Object)"zh", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForAllCN() throws Exception {
        this.localeAtRendering = new Locale("All", "CN");
        Assert.assertEquals((Object)"en", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForDefault() throws Exception {
        this.localeAtRendering = new Locale("All", "All");
        Assert.assertEquals((Object)"en", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForInvalidCountry() throws Exception {
        this.localeAtRendering = new Locale("zh", "foo");
        Assert.assertEquals((Object)"zh", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForInvalidLanguage() throws Exception {
        this.localeAtRendering = new Locale("foo", "CN");
        Assert.assertEquals((Object)"en", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    @Test
    public void localeNameForInvalidLanguageAndCountry() throws Exception {
        this.localeAtRendering = new Locale("foo", "foo");
        Assert.assertEquals((Object)"en", (Object)this.i18nRewriter.getLocaleNameForLoadingI18NConstants(this.localeAtRendering));
    }

    private static class FakeOpenSocialI18NGadgetRewriter
    extends OpenSocialI18NGadgetRewriter {
        private Map<String, String> resources = new HashMap<String, String>();

        public FakeOpenSocialI18NGadgetRewriter() {
            this.resources.put("features/i18n/data/DateTimeConstants__en.js", "content for en");
            this.resources.put("features/i18n/data/DateTimeConstants__en_US.js", "content for en_US");
            this.resources.put("features/i18n/data/DateTimeConstants__zh.js", "content for zh");
            this.resources.put("features/i18n/data/DateTimeConstants__zh_CN.js", "content for zh_CN");
        }

        protected String attemptToLoadResource(String localeName) throws IOException {
            String resource = "features/i18n/data/DateTimeConstants__" + localeName + ".js";
            if (this.resources.containsKey(resource)) {
                return this.resources.get(resource);
            }
            throw new IOException("Resource Unavailable.");
        }
    }
}

