/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.apache.shindig.gadgets.rewrite.BaseRewriterTestCase;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.junit.Assert;
import org.junit.Test;

public class ContentRewriterFeatureTestCase
extends BaseRewriterTestCase {
    @Test
    public void testContainerDefaultIncludeAll() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), ".*", "", "0", this.tags);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testContainerDefaultIncludeNone() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), "", ".*", "0", this.tags);
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testContainerDefaultExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithoutRewrite(), ".*", ".*", "0", this.tags);
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecExcludeOverridesContainerDefaultInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("", ".*", "0", this.tags), ".*", "", "0", this.tags);
        Assert.assertFalse((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testSpecIncludeOverridesContainerDefaultExclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite(".*", "", "0", this.tags), "", ".*", "0", this.tags);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testExcludeOverridesInclude() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "test", "0", this.tags), "", "", "0", this.tags);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
    }

    @Test
    public void testIncludeOnlyMatch() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), "", "", "0", this.tags);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.isRewriteEnabled());
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://www.test.com"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteURL("http://testx.test.com"));
    }

    @Test
    public void testTagRewrite() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", this.tags), "", "", "0", this.tags);
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
    }

    @Test
    public void testOverrideTagRewrite() throws Exception {
        HashSet newTags = Sets.newHashSet((Object[])new String[]{"iframe"});
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "0", newTags), "", "", "0", this.tags);
        Assert.assertTrue((boolean)this.defaultRewriterFeature.shouldRewriteTag("IFRAME"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("img"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("ScripT"));
        Assert.assertFalse((boolean)this.defaultRewriterFeature.shouldRewriteTag("link"));
    }

    @Test
    public void testExpiresTimeParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "12345", this.tags), "", "", "0", this.tags);
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }

    @Test
    public void testExpiresHTTPParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "htTp ", this.tags), "", "", "12345", this.tags);
        Assert.assertNull((Object)this.defaultRewriterFeature.getExpires());
    }

    @Test
    public void testExpiresInvalidParse() throws Exception {
        this.defaultRewriterFeature = new ContentRewriterFeature(ContentRewriterFeatureTestCase.createSpecWithRewrite("test\\.com", "testx", "junk", this.tags), "", "", "12345", this.tags);
        Assert.assertNotNull((Object)this.defaultRewriterFeature.getExpires());
        Assert.assertNotNull((Object)(this.defaultRewriterFeature.getExpires() == 12345 ? 1 : 0));
    }
}

