/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.ParseModule;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;

public class MutableContentTest {
    private MutableContent mhc;

    @Before
    public void setUp() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new ParseModule(), new PropertiesModule()});
        this.mhc = new MutableContent((GadgetHtmlParser)injector.getInstance(GadgetHtmlParser.class), "DEFAULT VIEW");
    }

    @Test
    public void getContentAndParseTreeNoSets() throws Exception {
        String content = this.mhc.getContent();
        Assert.assertEquals((Object)"DEFAULT VIEW", (Object)content);
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)2L, (long)document.getFirstChild().getChildNodes().getLength());
        Assert.assertSame((Object)document.getFirstChild().getChildNodes().item(1).getFirstChild().getNodeType(), (Object)3);
        Assert.assertEquals((Object)content, (Object)document.getFirstChild().getChildNodes().item(1).getTextContent());
        Assert.assertSame((Object)content, (Object)this.mhc.getContent());
        Assert.assertSame((Object)document, (Object)this.mhc.getDocument());
    }

    @Test
    public void modifyContentReflectedInTree() throws Exception {
        this.mhc.setContent("NEW CONTENT");
        Document document = this.mhc.getDocument();
        Assert.assertEquals((long)1L, (long)document.getChildNodes().getLength());
        Assert.assertEquals((Object)"NEW CONTENT", (Object)document.getChildNodes().item(0).getTextContent());
    }

    @Test
    public void modifyTreeReflectedInContent() throws Exception {
        Document document = this.mhc.getDocument();
        document.getFirstChild().getFirstChild().setTextContent("FOO CONTENT");
        MutableContent.notifyEdit((Document)document);
        Assert.assertTrue((boolean)this.mhc.getContent().contains("FOO CONTENT"));
        document.getFirstChild().getFirstChild().setTextContent("BAR CONTENT");
        MutableContent.notifyEdit((Document)document);
        Assert.assertTrue((boolean)this.mhc.getContent().contains("BAR CONTENT"));
        Assert.assertSame((Object)document, (Object)this.mhc.getDocument());
    }
}

