/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.gadgets.servlet.JsonRpcGadgetContext;
import org.json.JSONObject;

public class JsonRpcGadgetContextTest
extends TestCase {
    static final String SPEC_URL = "http://example.org/gadget.xml";
    static final int SPEC_ID = 1234;
    static final String[] PREF_KEYS = new String[]{"hello", "foo"};
    static final String[] PREF_VALUES = new String[]{"world", "bar"};
    static final Map<String, String> prefs = Maps.newHashMap();

    public void testCorrectExtraction() throws Exception {
        JSONObject gadget = new JSONObject().put("url", (Object)SPEC_URL).put("moduleId", 1234).put("prefs", prefs).put("gadget-field", (Object)"gadget-value");
        JSONObject context = new JSONObject().put("language", (Object)Locale.US.getLanguage()).put("country", (Object)Locale.US.getCountry().toUpperCase()).put("context-field", (Object)"context-value");
        JsonRpcGadgetContext jsonContext = new JsonRpcGadgetContext(context, gadget);
        JsonRpcGadgetContextTest.assertEquals((String)SPEC_URL, (String)jsonContext.getUrl().toString());
        JsonRpcGadgetContextTest.assertEquals((int)1234, (int)jsonContext.getModuleId());
        JsonRpcGadgetContextTest.assertEquals((String)Locale.US.getLanguage(), (String)jsonContext.getLocale().getLanguage());
        JsonRpcGadgetContextTest.assertEquals((String)Locale.US.getCountry(), (String)jsonContext.getLocale().getCountry());
        for (String key : PREF_KEYS) {
            String value = jsonContext.getUserPrefs().getPref(key);
            JsonRpcGadgetContextTest.assertEquals((String)prefs.get(key), (String)value);
        }
        JsonRpcGadgetContextTest.assertEquals((String)"gadget-value", (String)jsonContext.getParameter("gadget-field"));
        JsonRpcGadgetContextTest.assertEquals((String)"context-value", (String)jsonContext.getParameter("context-field"));
    }

    static {
        int j = PREF_KEYS.length;
        for (int i = 0; i < j; ++i) {
            prefs.put(PREF_KEYS[i], PREF_VALUES[i]);
        }
    }
}

