/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.shindig.common.testing.TestExecutorService;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.JsonRpcHandler;
import org.apache.shindig.gadgets.servlet.RpcException;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRpcHandlerTest {
    private static final Uri SPEC_URL = Uri.parse((String)"http://example.org/g.xml");
    private static final Uri SPEC_URL2 = Uri.parse((String)"http://example.org/g2.xml");
    private static final String SPEC_TITLE = "JSON-TEST";
    private static final String SPEC_TITLE2 = "JSON-TEST2";
    private static final int PREFERRED_HEIGHT = 100;
    private static final int PREFERRED_WIDTH = 242;
    private static final String LINK_REL = "rel";
    private static final String LINK_HREF = "http://example.org/foo";
    private static final String SPEC_XML = "<Module><ModulePrefs title=\"JSON-TEST\">  <Link rel='rel' href='http://example.org/foo'/></ModulePrefs><UserPref name=\"up_one\">  <EnumValue value=\"val1\" display_value=\"disp1\"/>  <EnumValue value=\"abc\" display_value=\"disp2\"/>  <EnumValue value=\"z_xabc\" display_value=\"disp3\"/>  <EnumValue value=\"foo\" display_value=\"disp4\"/></UserPref><Content type=\"html\" preferred_height = \"100\" preferred_width = \"242\">Hello, world</Content></Module>";
    private static final String SPEC_XML2 = "<Module><ModulePrefs title=\"JSON-TEST2\"/><Content type=\"html\">Hello, world</Content></Module>";
    private final FakeProcessor processor = new FakeProcessor();
    private final FakeUrlGenerator urlGenerator = new FakeUrlGenerator();
    private final JsonRpcHandler jsonRpcHandler = new JsonRpcHandler((ExecutorService)new TestExecutorService(), (Processor)this.processor, (UrlGenerator)this.urlGenerator);

    private JSONObject createContext(String lang, String country) throws JSONException {
        return new JSONObject().put("language", (Object)lang).put("country", (Object)country);
    }

    @Before
    public void setUp() {
        this.processor.gadgets.put(SPEC_URL, SPEC_XML);
        this.processor.gadgets.put(SPEC_URL2, SPEC_XML2);
    }

    private JSONObject createGadget(String url, int moduleId, Map<String, String> prefs) throws JSONException {
        return new JSONObject().put("url", (Object)url).put("moduleId", moduleId).put("prefs", prefs == null ? Collections.emptySet() : prefs);
    }

    @Test
    public void testSimpleRequest() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(SPEC_URL.toString(), 0, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.urlGenerator.iframeUrl = SPEC_URL.toString();
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        JSONObject gadget = outGadgets.getJSONObject(0);
        Assert.assertEquals((Object)SPEC_URL.toString(), (Object)gadget.getString("iframeUrl"));
        Assert.assertEquals((Object)SPEC_TITLE, (Object)gadget.getString("title"));
        Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
        JSONObject view = gadget.getJSONObject("views").getJSONObject("default");
        Assert.assertEquals((long)100L, (long)view.getInt("preferredHeight"));
        Assert.assertEquals((long)242L, (long)view.getInt("preferredWidth"));
        Assert.assertEquals((Object)LINK_HREF, (Object)gadget.getJSONObject("links").getString(LINK_REL));
        JSONObject userPrefs = gadget.getJSONObject("userPrefs");
        Assert.assertNotNull((Object)userPrefs);
        JSONObject userPrefData = userPrefs.getJSONObject("up_one");
        Assert.assertNotNull((Object)userPrefData);
        JSONObject upEnums = userPrefData.getJSONObject("enumValues");
        Assert.assertNotNull((Object)upEnums);
        Assert.assertEquals((Object)"disp1", (Object)upEnums.get("val1"));
        Assert.assertEquals((Object)"disp2", (Object)upEnums.get("abc"));
        Assert.assertEquals((Object)"disp3", (Object)upEnums.get("z_xabc"));
        Assert.assertEquals((Object)"disp4", (Object)upEnums.get("foo"));
        JSONArray orderedEnums = userPrefData.getJSONArray("orderedEnumValues");
        Assert.assertNotNull((Object)orderedEnums);
        Assert.assertEquals((long)4L, (long)orderedEnums.length());
        Assert.assertEquals((Object)"val1", (Object)orderedEnums.getJSONObject(0).getString("value"));
        Assert.assertEquals((Object)"abc", (Object)orderedEnums.getJSONObject(1).getString("value"));
        Assert.assertEquals((Object)"z_xabc", (Object)orderedEnums.getJSONObject(2).getString("value"));
        Assert.assertEquals((Object)"foo", (Object)orderedEnums.getJSONObject(3).getString("value"));
    }

    @Test(expected=RpcException.class)
    public void testUnexpectedError() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(SPEC_URL.toString(), 0, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.urlGenerator.throwRandomFault = true;
        this.jsonRpcHandler.process(input);
    }

    @Test
    public void testMultipleGadgets() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(SPEC_URL.toString(), 0, null)).put((Object)this.createGadget(SPEC_URL2.toString(), 1, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        boolean first = false;
        boolean second = false;
        int j = outGadgets.length();
        for (int i = 0; i < j; ++i) {
            JSONObject gadget = outGadgets.getJSONObject(i);
            if (gadget.getString("url").equals(SPEC_URL.toString())) {
                Assert.assertEquals((Object)SPEC_TITLE, (Object)gadget.getString("title"));
                Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
                first = true;
                continue;
            }
            Assert.assertEquals((Object)SPEC_TITLE2, (Object)gadget.getString("title"));
            Assert.assertEquals((long)1L, (long)gadget.getInt("moduleId"));
            second = true;
        }
        Assert.assertTrue((String)"First gadget not returned!", (boolean)first);
        Assert.assertTrue((String)"Second gadget not returned!", (boolean)second);
    }

    @Test
    public void testMultipleGadgetsWithAnError() throws Exception {
        JSONArray gadgets = new JSONArray().put((Object)this.createGadget(SPEC_URL.toString(), 0, null)).put((Object)this.createGadget(SPEC_URL2.toString(), 1, null));
        JSONObject input = new JSONObject().put("context", (Object)this.createContext("en", "US")).put("gadgets", (Object)gadgets);
        this.processor.exceptions.put(SPEC_URL2, new ProcessingException("broken"));
        JSONObject response = this.jsonRpcHandler.process(input);
        JSONArray outGadgets = response.getJSONArray("gadgets");
        boolean first = false;
        boolean second = false;
        int j = outGadgets.length();
        for (int i = 0; i < j; ++i) {
            JSONObject gadget = outGadgets.getJSONObject(i);
            if (gadget.getString("url").equals(SPEC_URL.toString())) {
                Assert.assertEquals((Object)SPEC_TITLE, (Object)gadget.getString("title"));
                Assert.assertEquals((long)0L, (long)gadget.getInt("moduleId"));
                first = true;
                continue;
            }
            JSONArray errors = gadget.getJSONArray("errors");
            Assert.assertEquals((long)1L, (long)errors.length());
            Assert.assertEquals((Object)"broken", (Object)errors.optString(0));
            second = true;
        }
        Assert.assertTrue((String)"First gadget not returned!", (boolean)first);
        Assert.assertTrue((String)"Second gadget not returned!", (boolean)second);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FakeUrlGenerator
    implements UrlGenerator {
        protected boolean throwRandomFault = false;
        protected String iframeUrl = "http://example.org/gadgets/foo-does-not-matter";

        protected FakeUrlGenerator() {
        }

        public String getBundledJsParam(Collection<String> features, GadgetContext context) {
            throw new UnsupportedOperationException();
        }

        public String getBundledJsUrl(Collection<String> features, GadgetContext context) {
            throw new UnsupportedOperationException();
        }

        public String getIframeUrl(Gadget gadget) {
            if (this.throwRandomFault) {
                throw new RuntimeException("BROKEN");
            }
            return this.iframeUrl;
        }

        public String getGadgetDomainOAuthCallback(String container, String gadgetHost) {
            throw new UnsupportedOperationException();
        }
    }

    private static class FakeProcessor
    extends Processor {
        protected final Map<Uri, ProcessingException> exceptions = Maps.newHashMap();
        protected final Map<Uri, String> gadgets = Maps.newHashMap();

        public FakeProcessor() {
            super(null, null, null, null, null);
        }

        public Gadget process(GadgetContext context) throws ProcessingException {
            ProcessingException exception = this.exceptions.get(context.getUrl());
            if (exception != null) {
                throw exception;
            }
            try {
                GadgetSpec spec = new GadgetSpec(Uri.parse((String)"#"), this.gadgets.get(context.getUrl()));
                View view = spec.getView(context.getView());
                return new Gadget().setContext(context).setSpec(spec).setCurrentView(view);
            }
            catch (GadgetException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

