/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.spec;

import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.spec.ApplicationManifest;
import org.apache.shindig.gadgets.spec.SpecParserException;
import org.junit.Assert;
import org.junit.Test;

public class ApplicationManifestTest {
    private static final Uri BASE_URI = Uri.parse((String)"http://example.org/manifest.xml");

    @Test
    public void resolveRelativeUri() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version>  <spec>app.xml</spec></gadget></app>";
        ApplicationManifest manifest = new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
        Assert.assertEquals((Object)BASE_URI.resolve(Uri.parse((String)"app.xml")), (Object)manifest.getGadget("1.0"));
        Assert.assertEquals((Object)BASE_URI, (Object)manifest.getUri());
    }

    @Test(expected=SpecParserException.class)
    public void malformedUriThrows() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version>  <spec><![CDATA[$%&$%*$%&$%(]]></spec></gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }

    @Test
    public void getVersion() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>development</label>  <version>2.0</version>  <spec>whatever</spec></gadget><gadget>  <label>production</label>  <version>1.0</version>  <spec>whatever</spec></gadget></app>";
        ApplicationManifest manifest = new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
        Assert.assertEquals((Object)"1.0", (Object)manifest.getVersion("production"));
        Assert.assertEquals((Object)"2.0", (Object)manifest.getVersion("development"));
    }

    @Test(expected=SpecParserException.class)
    public void missingVersion() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <spec>whatever</spec></gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }

    @Test(expected=SpecParserException.class)
    public void tooManyVersions() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version>  <version>2.0</version>  <spec>whatever</spec></gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }

    @Test
    public void getGadget() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>development</label>  <version>2.0</version>  <spec>app2.xml</spec></gadget><gadget>  <label>production</label>  <version>1.0</version>  <spec>app.xml</spec></gadget></app>";
        ApplicationManifest manifest = new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
        Assert.assertEquals((Object)BASE_URI.resolve(Uri.parse((String)"app.xml")), (Object)manifest.getGadget("1.0"));
        Assert.assertEquals((Object)BASE_URI.resolve(Uri.parse((String)"app2.xml")), (Object)manifest.getGadget("2.0"));
    }

    @Test(expected=SpecParserException.class)
    public void missingSpec() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version></gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }

    @Test(expected=SpecParserException.class)
    public void tooManySpecs() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version>  <spec>whoever</spec>  <spec>whatever</spec></gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }

    @Test(expected=SpecParserException.class)
    public void selfReferencingManifest() throws Exception {
        String xml = "<app xmlns='http://ns.opensocial.org/2008/application'><gadget>  <label>production</label>  <version>1.0</version>  <spec>whoever</spec>  <spec>" + BASE_URI + "</spec>" + "</gadget></app>";
        new ApplicationManifest(BASE_URI, XmlUtil.parse((String)xml));
    }
}

