/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.apache.shindig.gadgets.templates.AbstractTagHandler;
import org.apache.shindig.gadgets.templates.CompositeTagRegistry;
import org.apache.shindig.gadgets.templates.DefaultTagRegistry;
import org.apache.shindig.gadgets.templates.TagHandler;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompositeTagRegistryTest {
    public static final String TEST_NAMESPACE = "#test";
    private TagHandler fooTag;
    private TagHandler fooTag2;
    private TagHandler barTag;
    private CompositeTagRegistry registry;

    @Before
    public void setUp() {
        this.fooTag = this.createTagHandler("foo");
        this.fooTag2 = this.createTagHandler("foo");
        this.barTag = this.createTagHandler("bar");
        DefaultTagRegistry first = new DefaultTagRegistry((Set)ImmutableSet.of((Object[])new TagHandler[]{this.fooTag, this.barTag}));
        DefaultTagRegistry second = new DefaultTagRegistry((Set)ImmutableSet.of((Object)this.fooTag2));
        this.registry = new CompositeTagRegistry((Collection)ImmutableList.of((Object)first, (Object)second));
    }

    @Test
    public void firstRegistryWins() {
        TagRegistry.NSName foo = new TagRegistry.NSName(TEST_NAMESPACE, "foo");
        Assert.assertSame((Object)this.fooTag, (Object)this.registry.getHandlerFor(foo));
    }

    @Test
    public void secondRegistryUsed() {
        TagRegistry.NSName bar = new TagRegistry.NSName(TEST_NAMESPACE, "bar");
        Assert.assertSame((Object)this.barTag, (Object)this.registry.getHandlerFor(bar));
    }

    @Test
    public void unknownNamesReturnNull() {
        TagRegistry.NSName baz = new TagRegistry.NSName(TEST_NAMESPACE, "baz");
        Assert.assertNull((Object)this.registry.getHandlerFor(baz));
    }

    private TagHandler createTagHandler(String name) {
        return new AbstractTagHandler(TEST_NAMESPACE, name){

            public void process(Node result, Element tag, TemplateProcessor processor) {
            }
        };
    }
}

