/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.logging.Logger;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.AbstractMessageBundleFactory;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;

@Singleton
public class DefaultMessageBundleFactory
extends AbstractMessageBundleFactory {
    public static final String CACHE_NAME = "messageBundles";
    static final Logger LOG = Logger.getLogger(DefaultMessageBundleFactory.class.getName());
    private final HttpFetcher fetcher;
    private final SoftExpiringCache<Uri, MessageBundle> cache;
    private final long refresh;

    @Inject
    public DefaultMessageBundleFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh) {
        this.fetcher = fetcher;
        Cache baseCache = cacheProvider.createCache(CACHE_NAME);
        this.cache = new SoftExpiringCache(baseCache);
        this.refresh = refresh;
    }

    protected MessageBundle fetchBundle(LocaleSpec locale, boolean ignoreCache) throws GadgetException {
        if (ignoreCache) {
            return this.fetchAndCacheBundle(locale, ignoreCache);
        }
        Uri uri = locale.getMessages();
        SoftExpiringCache.CachedObject cached = this.cache.getElement((Object)uri);
        MessageBundle bundle = null;
        if (cached == null || cached.isExpired) {
            try {
                bundle = this.fetchAndCacheBundle(locale, ignoreCache);
            }
            catch (GadgetException e) {
                bundle = cached != null ? (MessageBundle)cached.obj : MessageBundle.EMPTY;
                LOG.info("MessageBundle fetch failed for " + uri + " - using cached.");
                this.cache.addElement((Object)uri, (Object)bundle, this.refresh);
            }
        } else {
            bundle = (MessageBundle)cached.obj;
        }
        return bundle;
    }

    private MessageBundle fetchAndCacheBundle(LocaleSpec locale, boolean ignoreCache) throws GadgetException {
        Uri url = locale.getMessages();
        HttpRequest request = new HttpRequest(url).setIgnoreCache(ignoreCache);
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.fetcher.fetch(request);
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve message bundle xml. HTTP error " + response.getHttpStatusCode());
        }
        MessageBundle bundle = new MessageBundle(locale, response.getResponseAsString());
        this.cache.addElement((Object)url, (Object)bundle, this.refresh);
        return bundle;
    }
}

