/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Singleton
public class NekoHtmlParser
extends GadgetHtmlParser {
    private final DOMImplementation documentProvider;

    @Inject
    public NekoHtmlParser(DOMImplementation documentProvider) {
        this.documentProvider = documentProvider;
    }

    public Document parseDomImpl(String source) throws GadgetException {
        try {
            Document document = this.parseFragment(source);
            HtmlSerializer.attach(document, new Serializer(), source);
            return document;
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    private Document parseFragment(String source) throws SAXException, IOException {
        InputSource input = new InputSource(new StringReader(source));
        DOMFragmentParser parser = new DOMFragmentParser();
        parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
        parser.setFeature("http://cyberneko.org/html/features/document-fragment", true);
        Document htmlDoc = this.documentProvider.createDocument(null, null, null);
        DocumentFragment fragment = htmlDoc.createDocumentFragment();
        parser.parse(input, fragment);
        this.normalizeFragment(htmlDoc, fragment);
        return htmlDoc;
    }

    static class Serializer
    extends HtmlSerializer {
        static final OutputFormat outputFormat = new OutputFormat();

        Serializer() {
        }

        public String serializeImpl(Document doc) {
            StringWriter sw = Serializer.createWriter(doc);
            HTMLSerializer serializer = new HTMLSerializer((Writer)sw, outputFormat);
            try {
                serializer.serialize(doc);
                return sw.toString();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        static {
            outputFormat.setPreserveSpace(true);
            outputFormat.setPreserveEmptyAttributes(false);
        }
    }
}

