/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.CssRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.rewrite.RewriterUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CSSContentRewriter
implements ContentRewriter {
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final ContainerConfig config;
    static final String CONTENT_REWRITE_KEY = "gadgets.content-rewrite";
    static final String PROXY_URL_KEY = "proxy-url";

    @Inject
    public CSSContentRewriter(ContentRewriterFeatureFactory rewriterFeatureFactory, ContainerConfig config) {
        this.rewriterFeatureFactory = rewriterFeatureFactory;
        this.config = config;
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        return null;
    }

    public RewriterResults rewrite(HttpRequest request, HttpResponse original, MutableContent content) {
        if (!RewriterUtils.isCss(request, original)) {
            return null;
        }
        ContentRewriterFeature feature = this.rewriterFeatureFactory.get(request);
        content.setContent(CssRewriter.rewrite(content.getContent(), request.getUri(), this.createLinkRewriter(request.getGadget(), feature, request.getContainer())));
        return RewriterResults.cacheableIndefinitely();
    }

    protected LinkRewriter createLinkRewriter(Uri gadgetUri, ContentRewriterFeature feature, String container) {
        JSONObject contentRewrite = this.config.getJsonObject(container, CONTENT_REWRITE_KEY);
        try {
            return new ProxyingLinkRewriter(gadgetUri, feature, contentRewrite.getString(PROXY_URL_KEY));
        }
        catch (JSONException e) {
            return null;
        }
    }
}

