/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.opensocial.DefaultGadgetRewriter;
import com.google.caja.opensocial.GadgetRewriteException;
import com.google.caja.opensocial.UriCallback;
import com.google.caja.opensocial.UriCallbackException;
import com.google.caja.opensocial.UriCallbackOption;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;

public class CajaContentRewriter
implements ContentRewriter {
    private final Logger logger = Logger.getLogger(CajaContentRewriter.class.getName());

    public RewriterResults rewrite(HttpRequest req, HttpResponse resp, MutableContent content) {
        return null;
    }

    public RewriterResults rewrite(Gadget gadget, MutableContent content) {
        if (gadget.getSpec().getModulePrefs().getFeatures().containsKey("caja") || "1".equals(gadget.getContext().getParameter("caja"))) {
            final URI retrievedUri = gadget.getContext().getUrl();
            UriCallback cb = new UriCallback(){

                public UriCallbackOption getOption(ExternalReference externalReference, String string) {
                    return UriCallbackOption.REWRITE;
                }

                public Reader retrieve(ExternalReference externalReference, String string) throws UriCallbackException {
                    CajaContentRewriter.this.logger.info("Retrieving " + externalReference.toString());
                    try {
                        int n;
                        InputStreamReader in = new InputStreamReader(externalReference.getUri().toURL().openConnection().getInputStream(), "UTF-8");
                        char[] buf = new char[4096];
                        StringBuilder sb = new StringBuilder();
                        while ((n = in.read(buf)) > 0) {
                            sb.append(buf, 0, n);
                        }
                        return new StringReader(sb.toString());
                    }
                    catch (MalformedURLException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                    catch (IOException ex) {
                        throw new UriCallbackException(externalReference, (Throwable)ex);
                    }
                }

                public URI rewrite(ExternalReference externalReference, String string) {
                    return retrievedUri.resolve(externalReference.getUri());
                }
            };
            SimpleMessageQueue mq = new SimpleMessageQueue();
            DefaultGadgetRewriter rw = new DefaultGadgetRewriter((MessageQueue)mq);
            CharProducer input = CharProducer.Factory.create((Reader)new StringReader(content.getContent()), (FilePosition)FilePosition.instance((InputSource)new InputSource(retrievedUri), (int)2, (int)2, (int)1, (int)1));
            StringBuilder output = new StringBuilder();
            try {
                rw.rewriteContent(retrievedUri, input, cb, (Appendable)output);
            }
            catch (GadgetRewriteException e) {
                this.throwCajolingException((Exception)((Object)e), (MessageQueue)mq);
                return RewriterResults.notCacheable();
            }
            catch (IOException e) {
                this.throwCajolingException(e, (MessageQueue)mq);
                return RewriterResults.notCacheable();
            }
            content.setContent(output.toString());
        }
        return null;
    }

    private void throwCajolingException(Exception cause, MessageQueue mq) {
        StringBuilder errbuilder = new StringBuilder();
        MessageContext mc = new MessageContext();
        if (cause != null) {
            errbuilder.append(cause).append('\n');
        }
        for (Message m : mq.getMessages()) {
            errbuilder.append(m.format(mc)).append('\n');
        }
        this.logger.info("Unable to cajole gadget: " + errbuilder.toString());
    }
}

