/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthError;

public class OAuthResponseParams {
    public static final String CLIENT_STATE = "oauthState";
    public static final String APPROVAL_URL = "oauthApprovalUrl";
    public static final String ERROR_CODE = "oauthError";
    public static final String ERROR_TEXT = "oauthErrorText";
    private OAuthClientState newClientState;
    private String aznUrl;
    private OAuthError error;
    private String errorText;

    public OAuthResponseParams(BlobCrypter stateCrypter) {
        this.newClientState = new OAuthClientState(stateCrypter);
    }

    public void addToResponse(HttpResponseBuilder response) {
        if (!this.newClientState.isEmpty()) {
            try {
                response.setMetadata(CLIENT_STATE, this.newClientState.getEncryptedState());
            }
            catch (BlobCrypterException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.aznUrl != null) {
            response.setMetadata(APPROVAL_URL, this.aznUrl);
        }
        if (this.error != null) {
            response.setMetadata(ERROR_CODE, this.error.toString());
        }
        if (this.errorText != null) {
            response.setMetadata(ERROR_TEXT, this.errorText);
        }
    }

    public OAuthClientState getNewClientState() {
        return this.newClientState;
    }

    public String getAznUrl() {
        return this.aznUrl;
    }

    public void setAznUrl(String aznUrl) {
        this.aznUrl = aznUrl;
    }

    public OAuthError getError() {
        return this.error;
    }

    public void setError(OAuthError error) {
        this.error = error;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public void setErrorText(String errorText) {
        this.errorText = errorText;
    }
}

