/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Set;
import java.util.Stack;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.apache.shindig.gadgets.parse.HtmlSerializer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xml.serialize.HTMLSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.cyberneko.html.HTMLConfiguration;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLEntities;
import org.cyberneko.html.HTMLScanner;
import org.cyberneko.html.HTMLTagBalancer;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Singleton
public class NekoSimplifiedHtmlParser
extends GadgetHtmlParser {
    private static final Set<String> elements = ImmutableSet.of((Object[])new String[]{"html", "body", "head", "link", "img", "style", "script", "embed"});
    private final DOMImplementation documentFactory;

    @Inject
    public NekoSimplifiedHtmlParser(DOMImplementation documentFactory) {
        this.documentFactory = documentFactory;
    }

    protected Document parseDomImpl(String source) {
        HTMLScanner htmlScanner = new HTMLScanner();
        HTMLTagBalancer tagBalancer = new HTMLTagBalancer();
        DocumentHandler handler = new DocumentHandler(source);
        tagBalancer.setDocumentHandler((XMLDocumentHandler)handler);
        htmlScanner.setDocumentHandler((XMLDocumentHandler)tagBalancer);
        HTMLConfiguration config = new HTMLConfiguration();
        config.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"match");
        config.setFeature("http://cyberneko.org/html/features/balance-tags/document-fragment", true);
        tagBalancer.reset((XMLComponentManager)config);
        htmlScanner.reset((XMLComponentManager)config);
        XMLInputSource inputSource = new XMLInputSource(null, null, null);
        inputSource.setEncoding("UTF-8");
        inputSource.setCharacterStream((Reader)new StringReader(source));
        try {
            htmlScanner.setInputSource(inputSource);
            htmlScanner.scanDocument(true);
            Document document = handler.getDocument();
            DocumentFragment fragment = handler.getFragment();
            this.normalizeFragment(document, fragment);
            HtmlSerializer.attach(document, new Serializer(), source);
            return document;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    static class Serializer
    extends HtmlSerializer {
        static final OutputFormat outputFormat = new OutputFormat();

        Serializer() {
        }

        public String serializeImpl(Document doc) {
            StringWriter sw = Serializer.createWriter(doc);
            HTMLSerializer serializer = new HTMLSerializer(sw, outputFormat){

                protected void characters(String s) throws IOException {
                    this.content();
                    this._printer.printText(s);
                }
            };
            try {
                serializer.serialize(doc);
                return sw.toString();
            }
            catch (IOException ioe) {
                return null;
            }
        }

        static {
            outputFormat.setPreserveSpace(true);
            outputFormat.setPreserveEmptyAttributes(false);
        }
    }

    private class DocumentHandler
    implements XMLDocumentHandler {
        private final Stack<Node> elementStack = new Stack();
        private final StringBuilder builder;
        private DocumentFragment documentFragment;
        private Document document;

        public DocumentHandler(String content) {
            this.builder = new StringBuilder(content.length() / 10);
        }

        public DocumentFragment getFragment() {
            return this.documentFragment;
        }

        public Document getDocument() {
            return this.document;
        }

        public void startDocument(XMLLocator xmlLocator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, null);
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void xmlDecl(String version, String encoding, String standalone, Augmentations augs) throws XNIException {
            this.builder.append("<?xml");
            if (version != null) {
                this.builder.append(" version=\"").append(version).append("\"");
            }
            if (encoding != null) {
                this.builder.append(" encoding=\"").append(encoding).append("\"");
            }
            if (standalone != null) {
                this.builder.append(" standalone=\"").append(standalone).append("\"");
            }
            this.builder.append(">");
        }

        public void doctypeDecl(String rootElement, String publicId, String systemId, Augmentations augs) throws XNIException {
            this.document = NekoSimplifiedHtmlParser.this.documentFactory.createDocument(null, null, NekoSimplifiedHtmlParser.this.documentFactory.createDocumentType(rootElement, publicId, systemId));
            this.elementStack.clear();
            this.documentFragment = this.document.createDocumentFragment();
            this.elementStack.push(this.documentFragment);
        }

        public void comment(XMLString text, Augmentations augs) throws XNIException {
            this.builder.append("<!--").append(text.ch, text.offset, text.length).append("-->");
        }

        public void processingInstruction(String s, XMLString xmlString, Augmentations augs) throws XNIException {
        }

        public void startElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            if (elements.contains(qName.rawname.toLowerCase())) {
                if (this.builder.length() > 0) {
                    this.elementStack.peek().appendChild(this.document.createTextNode(this.builder.toString()));
                    this.builder.setLength(0);
                }
                Element element = this.document.createElement(qName.rawname);
                for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                    element.setAttribute(xmlAttributes.getLocalName(i), xmlAttributes.getValue(i));
                }
                this.elementStack.peek().appendChild(element);
                this.elementStack.push(element);
            } else {
                this.builder.append("<").append(qName.rawname);
                for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                    this.builder.append(" ").append(xmlAttributes.getLocalName(i)).append("=\"");
                    this.appendAttributeValue(xmlAttributes.getValue(i));
                    this.builder.append("\"");
                }
                this.builder.append(">");
            }
        }

        public void emptyElement(QName qName, XMLAttributes xmlAttributes, Augmentations augs) throws XNIException {
            if (elements.contains(qName.rawname.toLowerCase())) {
                if (this.builder.length() > 0) {
                    this.elementStack.peek().appendChild(this.document.createTextNode(this.builder.toString()));
                    this.builder.setLength(0);
                }
                Element element = this.document.createElement(qName.rawname);
                for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                    element.setAttribute(xmlAttributes.getLocalName(i), xmlAttributes.getValue(i));
                }
                this.elementStack.peek().appendChild(element);
            } else {
                this.builder.append("<").append(qName.rawname);
                for (int i = 0; i < xmlAttributes.getLength(); ++i) {
                    this.builder.append(" ").append(xmlAttributes.getLocalName(i)).append("=\"");
                    this.appendAttributeValue(xmlAttributes.getValue(i));
                    this.builder.append("\"");
                }
                this.builder.append(">");
            }
        }

        private void appendAttributeValue(String text) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    this.builder.append("&quot;");
                    continue;
                }
                this.builder.append(c);
            }
        }

        public void startGeneralEntity(String name, XMLResourceIdentifier id, String encoding, Augmentations augs) throws XNIException {
            if (name.startsWith("#")) {
                try {
                    boolean hex = name.startsWith("#x");
                    int offset = hex ? 2 : 1;
                    int base = hex ? 16 : 10;
                    int value = Integer.parseInt(name.substring(offset), base);
                    String entity = HTMLEntities.get((int)value);
                    if (entity != null) {
                        name = entity;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.printEntity(name);
        }

        private void printEntity(String name) {
            this.builder.append('&');
            this.builder.append(name);
            this.builder.append(';');
        }

        public void textDecl(String s, String s1, Augmentations augs) throws XNIException {
            this.builder.append(s);
        }

        public void endGeneralEntity(String s, Augmentations augs) throws XNIException {
        }

        public void characters(XMLString text, Augmentations augs) throws XNIException {
            if (HTMLElements.getElement((String)this.elementStack.peek().getNodeName()).isSpecial()) {
                this.builder.append(text.ch, text.offset, text.length);
            } else {
                for (int i = 0; i < text.length; ++i) {
                    char c = text.ch[text.offset + i];
                    if (c != '\n') {
                        String entity = HTMLEntities.get((int)c);
                        if (entity != null) {
                            this.printEntity(entity);
                            continue;
                        }
                        this.builder.append(c);
                        continue;
                    }
                    this.builder.append("\n");
                }
            }
        }

        public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
            this.builder.append(text.ch, text.offset, text.length);
        }

        public void endElement(QName qName, Augmentations augs) throws XNIException {
            if (elements.contains(qName.rawname.toLowerCase())) {
                if (this.builder.length() > 0) {
                    this.elementStack.peek().appendChild(this.document.createTextNode(this.builder.toString()));
                    this.builder.setLength(0);
                }
                this.elementStack.pop();
            } else {
                this.builder.append("</").append(qName.rawname).append(">");
            }
        }

        public void startCDATA(Augmentations augs) throws XNIException {
        }

        public void endCDATA(Augmentations augs) throws XNIException {
        }

        public void endDocument(Augmentations augs) throws XNIException {
            if (this.builder.length() > 0) {
                this.elementStack.peek().appendChild(this.document.createTextNode(this.builder.toString()));
                this.builder.setLength(0);
            }
            this.elementStack.pop();
        }

        public void setDocumentSource(XMLDocumentSource xmlDocumentSource) {
        }

        public XMLDocumentSource getDocumentSource() {
            return null;
        }
    }
}

