/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetFeature;
import org.apache.shindig.gadgets.GadgetFeatureRegistry;
import org.apache.shindig.gadgets.JsLibrary;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UnsupportedFeatureException;
import org.apache.shindig.gadgets.UrlGenerator;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.parse.DomUtil;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.Preloads;
import org.apache.shindig.gadgets.rewrite.ContentRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewriterResults;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LocaleSpec;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenderingContentRewriter
implements ContentRewriter {
    private static final Logger LOG = Logger.getLogger(RenderingContentRewriter.class.getName());
    static final String DEFAULT_HEAD_CONTENT = "body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}";
    static final String INSERT_BASE_ELEMENT_KEY = "gadgets.insertBaseElement";
    static final String FEATURES_KEY = "gadgets.features";
    private final MessageBundleFactory messageBundleFactory;
    private final ContainerConfig containerConfig;
    private final GadgetFeatureRegistry featureRegistry;
    private final UrlGenerator urlGenerator;

    @Inject
    public RenderingContentRewriter(MessageBundleFactory messageBundleFactory, ContainerConfig containerConfig, GadgetFeatureRegistry featureRegistry, UrlGenerator urlGenerator) {
        this.messageBundleFactory = messageBundleFactory;
        this.containerConfig = containerConfig;
        this.featureRegistry = featureRegistry;
        this.urlGenerator = urlGenerator;
    }

    @Override
    public RewriterResults rewrite(HttpRequest req, HttpResponse resp, MutableContent content) {
        return null;
    }

    @Override
    public RewriterResults rewrite(Gadget gadget, MutableContent mutableContent) {
        try {
            Element head = (Element)DomUtil.getFirstNamedChildNode(mutableContent.getDocument().getDocumentElement(), "head");
            ArrayList existingHeadContent = Lists.newArrayList();
            NodeList children = head.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                existingHeadContent.add(children.item(i));
            }
            for (Node n : existingHeadContent) {
                head.removeChild(n);
            }
            Element defaultStyle = head.getOwnerDocument().createElement("style");
            defaultStyle.setAttribute("type", "text/css");
            head.appendChild(defaultStyle);
            defaultStyle.appendChild(defaultStyle.getOwnerDocument().createTextNode(DEFAULT_HEAD_CONTENT));
            this.injectBaseTag(gadget, head);
            this.injectFeatureLibraries(gadget, head);
            Element mainScriptTag = head.getOwnerDocument().createElement("script");
            this.injectMessageBundles(gadget, mainScriptTag);
            this.injectDefaultPrefs(gadget, mainScriptTag);
            this.injectPreloads(gadget, mainScriptTag);
            head.appendChild(mainScriptTag);
            Element body = (Element)DomUtil.getFirstNamedChildNode(mutableContent.getDocument().getDocumentElement(), "body");
            LocaleSpec localeSpec = gadget.getLocale();
            if (localeSpec != null) {
                body.setAttribute("dir", localeSpec.getLanguageDirection());
            }
            this.injectOnLoadHandlers(body);
            for (Node n : existingHeadContent) {
                head.appendChild(n);
            }
            MutableContent.notifyEdit(mutableContent.getDocument());
            return RewriterResults.notCacheable();
        }
        catch (GadgetException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectBaseTag(Gadget gadget, Node headTag) {
        GadgetContext context = gadget.getContext();
        if ("true".equals(this.containerConfig.get(context.getContainer(), INSERT_BASE_ELEMENT_KEY))) {
            Uri base = gadget.getSpec().getUrl();
            View view = gadget.getCurrentView();
            if (view != null && view.getHref() != null) {
                base = view.getHref();
            }
            Element baseTag = headTag.getOwnerDocument().createElement("base");
            baseTag.setAttribute("href", base.toString());
            headTag.appendChild(baseTag);
        }
    }

    private void injectOnLoadHandlers(Node bodyTag) {
        Element onloadScript = bodyTag.getOwnerDocument().createElement("script");
        bodyTag.appendChild(onloadScript);
        onloadScript.appendChild(bodyTag.getOwnerDocument().createTextNode("gadgets.util.runOnLoadHandlers();"));
    }

    private void injectFeatureLibraries(Gadget gadget, Node headTag) throws GadgetException {
        GadgetContext context = gadget.getContext();
        GadgetSpec spec = gadget.getSpec();
        String forcedLibs = context.getParameter("libs");
        HashSet forced = forcedLibs == null || forcedLibs.length() == 0 ? Sets.newHashSet() : Sets.newHashSet((Object[])forcedLibs.split(":"));
        if (!forced.isEmpty()) {
            String jsUrl = this.urlGenerator.getBundledJsUrl(forced, context);
            Element libsTag = headTag.getOwnerDocument().createElement("script");
            libsTag.setAttribute("src", jsUrl.toString());
            headTag.appendChild(libsTag);
            for (GadgetFeature dep : this.featureRegistry.getFeatures(forced)) {
                forced.add(dep.getName());
            }
        }
        StringBuilder inlineJs = new StringBuilder();
        String container = context.getContainer();
        Collection<GadgetFeature> features = this.getFeatures(spec, forced);
        for (GadgetFeature feature : features) {
            for (JsLibrary library : feature.getJsLibraries(RenderingContext.GADGET, container)) {
                if (library.getType().equals((Object)JsLibrary.Type.URL)) {
                    if (inlineJs.length() > 0) {
                        Element inlineTag = headTag.getOwnerDocument().createElement("script");
                        headTag.appendChild(inlineTag);
                        inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
                        inlineJs.setLength(0);
                    }
                    Element referenceTag = headTag.getOwnerDocument().createElement("script");
                    referenceTag.setAttribute("src", library.getContent());
                    headTag.appendChild(referenceTag);
                    continue;
                }
                if (forced.contains(feature.getName())) continue;
                if (context.getDebug()) {
                    inlineJs.append(library.getDebugContent());
                } else {
                    inlineJs.append(library.getContent());
                }
                inlineJs.append(";\n");
            }
        }
        inlineJs.append(this.getLibraryConfig(gadget, features));
        if (inlineJs.length() > 0) {
            Element inlineTag = headTag.getOwnerDocument().createElement("script");
            headTag.appendChild(inlineTag);
            inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(inlineJs.toString()));
        }
    }

    private Collection<GadgetFeature> getFeatures(GadgetSpec spec, Collection<String> forced) throws GadgetException {
        Map<String, Feature> features = spec.getModulePrefs().getFeatures();
        HashSet libs = Sets.newHashSet(features.keySet());
        if (!forced.isEmpty()) {
            libs.addAll(forced);
        }
        HashSet<String> unsupported = new HashSet<String>();
        Collection<GadgetFeature> feats = this.featureRegistry.getFeatures(libs, unsupported);
        unsupported.removeAll(forced);
        if (!unsupported.isEmpty()) {
            Iterator missingIter = unsupported.iterator();
            while (missingIter.hasNext()) {
                String missing = (String)missingIter.next();
                if (features.get(missing).getRequired()) continue;
                missingIter.remove();
            }
            if (!unsupported.isEmpty()) {
                throw new UnsupportedFeatureException(((Object)unsupported).toString());
            }
        }
        return feats;
    }

    private String getLibraryConfig(Gadget gadget, Collection<GadgetFeature> reqs) throws GadgetException {
        GadgetContext context = gadget.getContext();
        JSONObject features = this.containerConfig.getJsonObject(context.getContainer(), FEATURES_KEY);
        try {
            JSONObject config;
            if (features == null) {
                config = new JSONObject();
            } else {
                String[] properties = new String[reqs.size()];
                int i = 0;
                for (GadgetFeature gadgetFeature : reqs) {
                    properties[i++] = gadgetFeature.getName();
                }
                config = new JSONObject(features, properties);
            }
            ModulePrefs prefs = gadget.getSpec().getModulePrefs();
            JSONObject featureMap = new JSONObject();
            for (Feature feature : prefs.getFeatures().values()) {
                featureMap.put(feature.getName(), feature.getParams());
            }
            config.put("core.util", (Object)featureMap);
            SecurityToken authToken = context.getToken();
            if (authToken != null) {
                String trustedJson;
                JSONObject jSONObject = new JSONObject();
                String updatedToken = authToken.getUpdatedToken();
                if (updatedToken != null) {
                    jSONObject.put("authToken", (Object)updatedToken);
                }
                if ((trustedJson = authToken.getTrustedJson()) != null) {
                    jSONObject.put("trustedJson", (Object)trustedJson);
                }
                config.put("shindig.auth", (Object)jSONObject);
            }
            return "gadgets.config.init(" + config.toString() + ");\n";
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectMessageBundles(Gadget gadget, Node scriptTag) throws GadgetException {
        GadgetContext context = gadget.getContext();
        MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), context.getLocale(), context.getIgnoreCache());
        String msgs = bundle.toJSONString();
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setMessages_(");
        text.appendData(msgs);
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    private void injectDefaultPrefs(Gadget gadget, Node scriptTag) {
        JSONObject defaultPrefs = new JSONObject();
        try {
            for (UserPref up : gadget.getSpec().getUserPrefs()) {
                defaultPrefs.put(up.getName(), (Object)up.getDefaultValue());
            }
        }
        catch (JSONException e) {
            // empty catch block
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setDefaultPrefs_(");
        text.appendData(defaultPrefs.toString());
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    private void injectPreloads(Gadget gadget, Node scriptTag) {
        JSONObject preload = new JSONObject();
        Preloads preloads = gadget.getPreloads();
        for (String name : preloads.getKeys()) {
            try {
                preload.put(name, preloads.getData(name).toJson());
            }
            catch (PreloadException e) {
                LOG.log(Level.WARNING, "Unexpected error attempting to preload " + name, e);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.io.preloaded_=");
        text.appendData(preload.toString());
        text.appendData(";");
        scriptTag.appendChild(text);
    }
}

