/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Utf8UrlCoder;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.FetchResponseUtils;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.ContentFetcherFactory;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.rewrite.ContentRewriterRegistry;
import org.apache.shindig.gadgets.servlet.ProxyBase;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class MakeRequestHandler
extends ProxyBase {
    public static final String UNPARSEABLE_CRUFT = "throw 1; < don't be evil' >";
    public static final String POST_DATA_PARAM = "postData";
    public static final String METHOD_PARAM = "httpMethod";
    public static final String HEADERS_PARAM = "headers";
    public static final String NOCACHE_PARAM = "nocache";
    public static final String CONTENT_TYPE_PARAM = "contentType";
    public static final String NUM_ENTRIES_PARAM = "numEntries";
    public static final String DEFAULT_NUM_ENTRIES = "3";
    public static final String GET_SUMMARIES_PARAM = "getSummaries";
    public static final String AUTHZ_PARAM = "authz";
    private final ContentFetcherFactory contentFetcherFactory;
    private final ContentRewriterRegistry contentRewriterRegistry;

    @Inject
    public MakeRequestHandler(ContentFetcherFactory contentFetcherFactory, ContentRewriterRegistry contentRewriterRegistry) {
        this.contentFetcherFactory = contentFetcherFactory;
        this.contentRewriterRegistry = contentRewriterRegistry;
    }

    public void fetch(HttpServletRequest request, HttpServletResponse response) throws GadgetException, IOException {
        HttpRequest rcr = this.buildHttpRequest(request);
        HttpResponse results = this.contentFetcherFactory.fetch(rcr);
        if (this.contentRewriterRegistry != null) {
            results = this.contentRewriterRegistry.rewriteHttpResponse(rcr, results);
        }
        String output = this.convertResponseToJson(rcr.getSecurityToken(), request, results);
        this.setResponseHeaders(request, response, results);
        response.setStatus(200);
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(UNPARSEABLE_CRUFT + output);
    }

    private HttpRequest buildHttpRequest(HttpServletRequest request) throws GadgetException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "UTF-8";
        }
        Uri url = this.validateUrl(request.getParameter("url"));
        HttpRequest req = new HttpRequest(url).setMethod(this.getParameter(request, METHOD_PARAM, "GET")).setPostBody(this.getParameter(request, POST_DATA_PARAM, "").getBytes()).setContainer(this.getContainer(request));
        String headerData = this.getParameter(request, HEADERS_PARAM, "");
        if (headerData.length() > 0) {
            String[] headerList;
            for (String header : headerList = headerData.split("&")) {
                String[] parts = header.split("=");
                if (parts.length != 2) {
                    throw new GadgetException(GadgetException.Code.INTERNAL_SERVER_ERROR, "Malformed header specified,");
                }
                req.addHeader(Utf8UrlCoder.decode((String)parts[0]), Utf8UrlCoder.decode((String)parts[1]));
            }
        }
        this.removeUnsafeHeaders(req);
        req.setIgnoreCache("1".equals(request.getParameter(NOCACHE_PARAM)));
        if (request.getParameter("gadget") != null) {
            req.setGadget(Uri.parse((String)request.getParameter("gadget")));
        }
        req.setRewriteMimeType(request.getParameter("rewriteMime"));
        AuthType auth = AuthType.parse(this.getParameter(request, AUTHZ_PARAM, null));
        req.setAuthType(auth);
        if (auth != AuthType.NONE) {
            req.setSecurityToken(this.extractAndValidateToken(request));
            req.setOAuthArguments(new OAuthArguments(auth, request));
        }
        return req;
    }

    private void removeUnsafeHeaders(HttpRequest request) {
        String[] badHeaders;
        for (String bad : badHeaders = new String[]{"Host", "Accept", "Accept-Encoding"}) {
            request.removeHeader(bad);
        }
    }

    private String convertResponseToJson(SecurityToken authToken, HttpServletRequest request, HttpResponse results) throws GadgetException {
        try {
            String updatedAuthToken;
            String originalUrl = request.getParameter("url");
            String body = results.getResponseAsString();
            if ("FEED".equals(request.getParameter(CONTENT_TYPE_PARAM))) {
                body = this.processFeed(originalUrl, request, body);
            }
            JSONObject resp = FetchResponseUtils.getResponseAsJson(results, body);
            if (authToken != null && (updatedAuthToken = authToken.getUpdatedToken()) != null) {
                resp.put("st", (Object)updatedAuthToken);
            }
            return new JSONObject().put(originalUrl, (Object)resp).toString();
        }
        catch (JSONException e) {
            return "";
        }
    }

    private SecurityToken extractAndValidateToken(HttpServletRequest request) throws GadgetException {
        SecurityToken token = new AuthInfo(request).getSecurityToken();
        if (token == null) {
            throw new GadgetException(GadgetException.Code.INVALID_SECURITY_TOKEN);
        }
        return token;
    }

    private String processFeed(String url, HttpServletRequest req, String xml) throws GadgetException {
        boolean getSummaries = Boolean.parseBoolean(this.getParameter(req, GET_SUMMARIES_PARAM, "false"));
        int numEntries = Integer.parseInt(this.getParameter(req, NUM_ENTRIES_PARAM, DEFAULT_NUM_ENTRIES));
        return new FeedProcessor().process(url, xml, getSummaries, numEntries).toString();
    }
}

