/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util.atom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.shindig.social.core.util.atom.AtomEntry;
import org.apache.shindig.social.core.util.atom.AtomLink;
import org.apache.shindig.social.opensocial.spi.DataCollection;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;

public class AtomFeed {
    private Collection entry;
    private int startIndex;
    private int totalResults;
    private int itemsPerPage;
    private String author;
    private AtomLink link;

    public AtomFeed(Object obj) {
        if (obj instanceof Map) {
            Map m = (Map)obj;
            this.entry = new ArrayList();
            for (Map.Entry o : m.entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else if (obj instanceof RestfulCollection) {
            RestfulCollection r = (RestfulCollection)obj;
            this.entry = new ArrayList();
            List entryList = r.getEntry();
            for (Object o : entryList) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = r.getStartIndex();
            this.totalResults = r.getTotalResults();
            this.itemsPerPage = entryList.size();
            this.author = "?";
            this.link = new AtomLink("rel", "???");
        } else if (obj instanceof DataCollection) {
            DataCollection dc = (DataCollection)obj;
            this.entry = new ArrayList();
            for (Map.Entry<String, Map<String, String>> o : dc.getEntry().entrySet()) {
                this.entry.add(new AtomEntry(o));
            }
            this.startIndex = 0;
            this.totalResults = this.entry.size();
            this.itemsPerPage = this.entry.size();
        } else {
            this.entry = new ArrayList();
            this.entry.add(new AtomEntry(obj));
            this.startIndex = 0;
            this.totalResults = 1;
            this.itemsPerPage = 1;
        }
    }
}

