/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.social.opensocial.service.BeanConverter;
import org.apache.shindig.social.opensocial.service.RequestItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulRequestItem
extends RequestItem {
    protected static final String X_HTTP_METHOD_OVERRIDE = "X-HTTP-Method-Override";
    private String url;
    private Map<String, List<String>> params;
    private String postData;

    public RestfulRequestItem(String service, String method, SecurityToken token, BeanConverter converter) {
        super(service, method, token, converter);
    }

    public RestfulRequestItem(String path, String method, String postData, SecurityToken token, BeanConverter converter) {
        super(RestfulRequestItem.getServiceFromPath(path), method, token, converter);
        this.postData = postData;
        this.url = path;
        this.putUrlParamsIntoParameters();
    }

    public RestfulRequestItem(HttpServletRequest servletRequest, SecurityToken token, BeanConverter converter) {
        super(RestfulRequestItem.getServiceFromPath(servletRequest.getPathInfo()), RestfulRequestItem.getMethod(servletRequest), token, converter);
        this.url = servletRequest.getPathInfo();
        this.params = RestfulRequestItem.createParameterMap(servletRequest);
        try {
            ServletInputStream is = servletRequest.getInputStream();
            this.postData = IOUtils.toString((InputStream)is, (String)servletRequest.getCharacterEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not get the post data from the request", e);
        }
    }

    static String getServiceFromPath(String pathInfo) {
        int indexOfNextPathSeparator = (pathInfo = pathInfo.substring(1)).indexOf(47);
        if (indexOfNextPathSeparator != -1) {
            return pathInfo.substring(0, indexOfNextPathSeparator);
        }
        return pathInfo;
    }

    static String getMethod(HttpServletRequest request) {
        String override = request.getParameter(X_HTTP_METHOD_OVERRIDE);
        if (!StringUtils.isBlank((String)override)) {
            return override;
        }
        return request.getMethod();
    }

    private static Map<String, List<String>> createParameterMap(HttpServletRequest servletRequest) {
        HashMap parameters = Maps.newHashMap();
        Enumeration names = servletRequest.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object[] paramValues = servletRequest.getParameterValues(name);
            parameters.put(name, Lists.newArrayList((Object[])paramValues));
        }
        return parameters;
    }

    void putUrlParamsIntoParameters() {
        String fullUrl;
        int queryParamIndex;
        if (this.params == null) {
            this.params = Maps.newHashMap();
        }
        if ((queryParamIndex = (fullUrl = this.url).indexOf(63)) != -1) {
            this.url = fullUrl.substring(0, queryParamIndex);
            String queryParams = fullUrl.substring(queryParamIndex + 1);
            for (String param : queryParams.split("&")) {
                String[] paramPieces = param.split("=", 2);
                ArrayList paramList = this.params.get(paramPieces[0]);
                if (paramList == null) {
                    paramList = Lists.newArrayListWithCapacity((int)1);
                    this.params.put(paramPieces[0], paramList);
                }
                if (paramPieces.length == 2) {
                    paramList.add(paramPieces[1]);
                    continue;
                }
                paramList.add("");
            }
        }
    }

    @Override
    public void applyUrlTemplate(String urlTemplate) {
        this.putUrlParamsIntoParameters();
        String[] actualUrl = this.url.split("/");
        String[] expectedUrl = urlTemplate.split("/");
        for (int i = 0; i < actualUrl.length; ++i) {
            String actualPart = actualUrl[i];
            String expectedPart = expectedUrl[i];
            if (!expectedPart.startsWith("{")) continue;
            if (expectedPart.endsWith("}+")) {
                this.params.put(expectedPart.substring(1, expectedPart.length() - 2), Lists.newArrayList((Object[])actualPart.split(",")));
                continue;
            }
            if (actualPart.indexOf(44) != -1) {
                throw new IllegalArgumentException("Cannot expect plural value " + actualPart + " for singular field " + expectedPart + " in " + this.url);
            }
            this.params.put(expectedPart.substring(1, expectedPart.length() - 1), Lists.newArrayList((Object[])new String[]{actualPart}));
        }
    }

    @Override
    public <T> T getTypedParameter(String parameterName, Class<T> dataTypeClass) {
        return this.getTypedParameters(dataTypeClass);
    }

    @Override
    public <T> T getTypedParameters(Class<T> dataTypeClass) {
        return this.converter.convertToObject(this.postData, dataTypeClass);
    }

    Map<String, List<String>> getParameters() {
        return this.params;
    }

    void setParameter(String paramName, String paramValue) {
        if (paramValue == null) {
            return;
        }
        this.params.put(paramName, Lists.newArrayList((Object[])new String[]{paramValue}));
    }

    void setListParameter(String paramName, List<String> paramValue) {
        this.params.put(paramName, paramValue);
    }

    @Override
    public String getParameter(String paramName) {
        List<String> paramValue = this.params.get(paramName);
        if (paramValue != null && !paramValue.isEmpty()) {
            return paramValue.get(0);
        }
        return null;
    }

    @Override
    public String getParameter(String paramName, String defaultValue) {
        String result = this.getParameter(paramName);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    @Override
    public List<String> getListParameter(String paramName) {
        List<String> stringList = this.params.get(paramName);
        if (stringList == null) {
            return Collections.emptyList();
        }
        if (stringList.size() == 1 && stringList.get(0).indexOf(44) != -1) {
            stringList = Arrays.asList(stringList.get(0).split(","));
            this.params.put(paramName, stringList);
        }
        return stringList;
    }
}

