/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.dataservice.integration.AbstractLargeRestfulTests;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.util.XSDValidator;
import org.junit.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestfulXmlActivityTest
extends AbstractLargeRestfulTests {
    private static final String XMLSCHEMA = " xmlns=\"http://ns.opensocial.org/2008/opensocial\" \n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ";
    private static final String XSDRESOURCE = "opensocial.xsd";
    private Activity johnsActivity;
    private XPathFactory xpathFactory;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.johnsActivity = new ActivityImpl("1", "john.doe");
        this.johnsActivity.setTitle("yellow");
        this.johnsActivity.setBody("what a color!");
        this.xpathFactory = XPathFactory.newInstance();
    }

    @Test
    public void testGetActivityJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self/@app/1", "GET", "xml", "application/xml");
        XSDValidator.validate(resp, XMLSCHEMA, XSDRESOURCE, false);
        InputSource source = new InputSource(new StringReader(resp));
        XPath xp = this.xpathFactory.newXPath();
        NodeList result = (NodeList)xp.evaluate("/response/activity", source, XPathConstants.NODESET);
        RestfulXmlActivityTest.assertEquals((int)1, (int)result.getLength());
        Node n = result.item(0);
        Map<String, List<String>> v = this.childNodesToMap(n);
        RestfulXmlActivityTest.assertEquals((int)4, (int)v.size());
        this.assertActivitiesEqual(this.johnsActivity, v);
    }

    @Test
    public void testGetActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validate(resp, XMLSCHEMA, XSDRESOURCE, false);
        XPath xp = this.xpathFactory.newXPath();
        RestfulXmlActivityTest.assertEquals((String)"0", (String)xp.evaluate("/response/startIndex", new InputSource(new StringReader(resp))));
        RestfulXmlActivityTest.assertEquals((String)"1", (String)xp.evaluate("/response/totalResults", new InputSource(new StringReader(resp))));
        NodeList nl = (NodeList)xp.evaluate("/response/entry/activity", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        RestfulXmlActivityTest.assertEquals((int)1, (int)nl.getLength());
        this.assertActivitiesEqual(this.johnsActivity, this.childNodesToMap(nl.item(0)));
    }

    @Test
    public void testGetFriendsActivitiesJson() throws Exception {
        String resp = this.getResponse("/activities/john.doe/@friends", "GET", "xml", "application/xml");
        XSDValidator.validate(resp, XMLSCHEMA, XSDRESOURCE, false);
        XPath xp = this.xpathFactory.newXPath();
        RestfulXmlActivityTest.assertEquals((String)"0", (String)xp.evaluate("/response/startIndex", new InputSource(new StringReader(resp))));
        RestfulXmlActivityTest.assertEquals((String)"2", (String)xp.evaluate("/response/totalResults", new InputSource(new StringReader(resp))));
        NodeList nl = (NodeList)xp.evaluate("/response/entry", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        RestfulXmlActivityTest.assertEquals((int)2, (int)nl.getLength());
    }

    private void assertActivitiesEqual(Activity activity, Map<String, List<String>> result) {
        RestfulXmlActivityTest.assertEquals((String)activity.getId(), (String)result.get("id").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getUserId(), (String)result.get("userId").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getTitle(), (String)result.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((String)activity.getBody(), (String)result.get("body").get(0));
    }

    @Test
    public void testCreateActivity() throws Exception {
        String postData = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<activity><body>and dad.</body><title>hi mom!</title></activity>";
        String createResponse = this.getResponse("/activities/john.doe/@self", "POST", postData, "xml", "application/xml");
        XSDValidator.validate(createResponse, XMLSCHEMA, XSDRESOURCE, false);
        String resp = this.getResponse("/activities/john.doe/@self", "GET", "xml", "application/xml");
        XSDValidator.validate(resp, XMLSCHEMA, XSDRESOURCE, false);
        XPath xp = this.xpathFactory.newXPath();
        RestfulXmlActivityTest.assertEquals((String)"0", (String)xp.evaluate("/response/startIndex", new InputSource(new StringReader(resp))));
        RestfulXmlActivityTest.assertEquals((String)"2", (String)xp.evaluate("/response/totalResults", new InputSource(new StringReader(resp))));
        NodeList nl = (NodeList)xp.evaluate("/response/entry/activity", new InputSource(new StringReader(resp)), XPathConstants.NODESET);
        RestfulXmlActivityTest.assertEquals((int)2, (int)nl.getLength());
        Map<String, List<String>> v = this.childNodesToMap(nl.item(0));
        if (v.containsKey("id")) {
            v = this.childNodesToMap(nl.item(1));
        }
        RestfulXmlActivityTest.assertEquals((String)"hi mom!", (String)v.get("title").get(0));
        RestfulXmlActivityTest.assertEquals((String)"and dad.", (String)v.get("body").get(0));
    }
}

