/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.spi;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import junit.framework.TestCase;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.core.util.ContainerConf;
import org.apache.shindig.social.core.util.JsonContainerConf;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.RequestItem;
import org.apache.shindig.social.opensocial.service.RestfulRequestItem;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;

public class DataRequestHandlerTest
extends TestCase {
    private DataRequestHandler drh;

    protected void setUp() throws Exception {
        JsonContainerConf containerConf = new JsonContainerConf();
        this.drh = new DataRequestHandler((ContainerConf)containerConf){

            protected Future<?> handleDelete(RequestItem request) {
                return ImmediateFuture.newInstance((Object)"DELETE");
            }

            protected Future<?> handlePut(RequestItem request) {
                return ImmediateFuture.newInstance((Object)"PUT");
            }

            protected Future<?> handlePost(RequestItem request) {
                return ImmediateFuture.newInstance((Object)"POST");
            }

            protected Future<?> handleGet(RequestItem request) {
                return ImmediateFuture.newInstance((Object)"GET");
            }
        };
    }

    public void testHandleItemSuccess() throws Exception {
        this.verifyItemDispatchMethodCalled("DELETE");
        this.verifyItemDispatchMethodCalled("PUT");
        this.verifyItemDispatchMethodCalled("POST");
        this.verifyItemDispatchMethodCalled("GET");
    }

    private void verifyItemDispatchMethodCalled(String methodName) throws Exception {
        RestfulRequestItem request = new RestfulRequestItem(null, methodName, null, null);
        DataRequestHandlerTest.assertEquals((Object)methodName, this.drh.handleItem((RequestItem)request).get());
    }

    public void testHandleMethodWithInvalidMethod() throws Exception {
        this.verifyExceptionThrown(null);
        this.verifyExceptionThrown("  ");
        this.verifyExceptionThrown("HEAD");
    }

    private void verifyExceptionThrown(String methodName) throws Exception {
        RestfulRequestItem request = new RestfulRequestItem(null, methodName, null, null);
        Future err = this.drh.handleItem((RequestItem)request);
        try {
            err.get();
        }
        catch (ExecutionException ee) {
            DataRequestHandlerTest.assertTrue((boolean)(ee.getCause() instanceof SocialSpiException));
            SocialSpiException spe = (SocialSpiException)ee.getCause();
            DataRequestHandlerTest.assertEquals((Object)ResponseError.NOT_IMPLEMENTED, (Object)spe.getError());
        }
    }
}

