/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.social.JsonLibTestsGuiceModule;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.BeanJsonConverter;
import org.apache.shindig.social.core.util.BeanJsonLibConverter;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.json.JSONObject;

public class JsonConverterPerformancePerf
extends TestCase {
    private static final Log log = LogFactory.getLog(JsonConverterPerformancePerf.class);
    private static final int TEST_SIZE = 10000;
    private Person johnDoe;
    private Activity activity;
    private BeanJsonLibConverter beanJsonLibConverter;
    private BeanJsonConverter beanJsonConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        Injector injector = Guice.createInjector((Module[])new Module[]{new JsonLibTestsGuiceModule()});
        this.beanJsonLibConverter = (BeanJsonLibConverter)injector.getInstance(BeanJsonLibConverter.class);
        this.beanJsonConverter = new BeanJsonConverter(Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule()}));
    }

    public void testToJsonLibOnInheritedClassOutput() throws Exception {
        SpecialPerson[] spa = new SpecialPerson[10000];
        for (int i = 0; i < 10000; ++i) {
            spa[i] = new SpecialPerson(String.valueOf(i), "robot", "nonsense");
        }
        Runtime r = Runtime.getRuntime();
        r.gc();
        long memstart = r.totalMemory() - r.freeMemory();
        long startOutput = System.currentTimeMillis();
        String[] output = new String[10000];
        for (int i = 0; i < 10000; ++i) {
            output[i] = this.beanJsonLibConverter.convertToString((Object)spa[i]);
        }
        long endOutput = System.currentTimeMillis();
        long memend = r.totalMemory() - r.freeMemory();
        String[] serializeOutput = new String[10000];
        char[] source = output[0].toCharArray();
        r.gc();
        long stringsizeStart = r.totalMemory() - r.freeMemory();
        for (int i = 0; i < 10000; ++i) {
            serializeOutput[i] = new String(source);
        }
        long stringsizeEnd = r.totalMemory() - r.freeMemory();
        log.info((Object)("SF JSON Lib Output " + this.average(startOutput, endOutput, 10000) + " ms/conversion, " + (this.average(memstart, memend, 10000) - this.average(stringsizeStart, stringsizeEnd, 10000)) + " heap bytes/conversion, output packet consumed on average " + this.average(stringsizeStart, stringsizeEnd, 10000) + " for a string length of " + output[0].length()));
        log.info((Object)("Output Was [" + output[0] + "]"));
    }

    public void testToJsonLibOnInheritedClassInput() throws Exception {
        SpecialPerson[] spa = new SpecialPerson[10000];
        SpecialPerson[] sparesult = new SpecialPerson[10000];
        Runtime r = Runtime.getRuntime();
        r.gc();
        long personStart = r.totalMemory() - r.freeMemory();
        for (int i = 0; i < 10000; ++i) {
            spa[i] = new SpecialPerson(String.valueOf(i), "robot", "nonsense");
        }
        long personEnd = r.totalMemory() - r.freeMemory();
        String[] serializeOutput = new String[10000];
        r.gc();
        for (int i = 0; i < 10000; ++i) {
            serializeOutput[i] = this.beanJsonLibConverter.convertToString((Object)spa[i]);
        }
        r.gc();
        long memstart = r.totalMemory() - r.freeMemory();
        long startInput = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            sparesult[i] = (SpecialPerson)((Object)this.beanJsonLibConverter.convertToObject(serializeOutput[i], SpecialPerson.class));
        }
        long endInput = System.currentTimeMillis();
        long memend = r.totalMemory() - r.freeMemory();
        log.info((Object)("SF JSON Lib Input " + this.average(startInput, endInput, 10000) + " ms/conversion, " + (this.average(memstart, memend, 10000) - this.average(personStart, personEnd, 10000)) + " heap bytes/conversion, person object consumed on average " + this.average(personStart, personEnd, 10000)));
    }

    public void testToJsonOnInheritedClassOutput() throws Exception {
        SpecialPerson[] spa = new SpecialPerson[10000];
        for (int i = 0; i < 10000; ++i) {
            spa[i] = new SpecialPerson(String.valueOf(i), "robot", "nonsense");
        }
        Runtime r = Runtime.getRuntime();
        String[] output = new String[10000];
        r.gc();
        long memstart = r.totalMemory() - r.freeMemory();
        long startOutput = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            output[i] = ((JSONObject)this.beanJsonConverter.convertToJson((Object)spa[i])).toString();
        }
        long endOutput = System.currentTimeMillis();
        long memend = r.totalMemory() - r.freeMemory();
        String[] serializeOutput = new String[10000];
        char[] source = output[0].toCharArray();
        r.gc();
        long stringsizeStart = r.totalMemory() - r.freeMemory();
        for (int i = 0; i < 10000; ++i) {
            serializeOutput[i] = new String(source);
        }
        long stringsizeEnd = r.totalMemory() - r.freeMemory();
        log.info((Object)("ORG JSON Lib Output " + this.average(startOutput, endOutput, 10000) + " ms/conversion, " + (this.average(memstart, memend, 10000) - this.average(stringsizeStart, stringsizeEnd, 10000)) + " heap bytes/conversion, output packet consumed on average " + this.average(stringsizeStart, stringsizeEnd, 10000) + " for a string length of " + output[0].length()));
        log.info((Object)("Output Was [" + output[0] + "]"));
    }

    private float average(long start, long end, int testSize) {
        float r = end - start;
        return r /= (float)testSize;
    }

    public void XtestToJsonOnInheritedClassInput() throws Exception {
        SpecialPerson[] spa = new SpecialPerson[10000];
        SpecialPerson[] sparesult = new SpecialPerson[10000];
        Runtime r = Runtime.getRuntime();
        r.gc();
        long personStart = r.totalMemory() - r.freeMemory();
        for (int i = 0; i < 10000; ++i) {
            spa[i] = new SpecialPerson(String.valueOf(i), "robot", "nonsense");
        }
        long personEnd = r.totalMemory() - r.freeMemory();
        String[] serializeOutput = new String[10000];
        r.gc();
        for (int i = 0; i < 10000; ++i) {
            serializeOutput[i] = this.beanJsonConverter.convertToString((Object)spa[i]);
        }
        r.gc();
        long memstart = r.totalMemory() - r.freeMemory();
        long startInput = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            sparesult[i] = (SpecialPerson)((Object)this.beanJsonConverter.convertToObject(serializeOutput[i], SpecialPerson.class));
        }
        long endInput = System.currentTimeMillis();
        long memend = r.totalMemory() - r.freeMemory();
        log.info((Object)("SF JSON Lib Input " + this.average(startInput, endInput, 10000) + " ms/conversion, " + (this.average(memstart, memend, 10000) - this.average(personStart, personEnd, 10000)) + " heap bytes/conversion, person object consumed on average " + this.average(personStart, personEnd, 10000)));
    }

    public static class SpecialPerson
    extends PersonImpl {
        private String newfield;

        public SpecialPerson() {
        }

        public SpecialPerson(String id, String name, String newfield) {
            super(id, name, (Name)new NameImpl(name));
            this.newfield = newfield;
        }

        public String getNewfield() {
            return this.newfield;
        }

        public void setNewfield(String newfield) {
            this.newfield = newfield;
        }
    }
}

