/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class XSDValidator {
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String XMLDEC = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";
    protected static final Log log = LogFactory.getLog(XSDValidator.class);

    public static String validate(String xml, InputStream schema) {
        try {
            return XSDValidator.validate(new ByteArrayInputStream(xml.getBytes("UTF-8")), schema);
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
    }

    public static String validate(InputStream xml, InputStream schema) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        StringBuilder errors = new StringBuilder();
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance(W3C_XML_SCHEMA);
            Schema s = schemaFactory.newSchema(new StreamSource(schema));
            Validator validator = s.newValidator();
            final LSResourceResolver lsr = validator.getResourceResolver();
            validator.setResourceResolver(new LSResourceResolver(){

                public LSInput resolveResource(String arg0, String arg1, String arg2, String arg3, String arg4) {
                    log.info((Object)("resolveResource(" + arg0 + "," + arg1 + "," + arg2 + "," + arg3 + "," + arg4 + ")"));
                    return lsr.resolveResource(arg0, arg1, arg2, arg3, arg4);
                }
            });
            validator.validate(new StreamSource(xml));
        }
        catch (IOException e) {
        }
        catch (SAXException e) {
            errors.append(e.getMessage()).append("\n");
        }
        return errors.toString();
    }

    public static String insertSchema(String xml, String schemaStatement, boolean removeContainer) {
        if (xml == null || xml.trim().length() == 0) {
            return xml;
        }
        if (removeContainer) {
            if (xml.startsWith("<response>")) {
                xml = xml.substring("<response>".length());
            }
            if (xml.endsWith("</response>")) {
                xml = xml.substring(0, xml.length() - "</response>".length());
            }
        }
        xml = xml.trim();
        int start = 0;
        if (xml.startsWith("<?")) {
            start = xml.indexOf(">") + 1;
            int gt = xml.indexOf(62, start);
            if (gt > 0) {
                return xml.substring(0, gt) + schemaStatement + xml.substring(gt);
            }
        } else {
            int gt = xml.indexOf(62, start);
            if (gt > 0) {
                return XMLDEC + xml.substring(0, gt) + schemaStatement + xml.substring(gt);
            }
        }
        return xml;
    }

    public static String validate(String xmlFragment, String schemaStatement, String schemaResource, boolean removeContainer) {
        String xml = XSDValidator.insertSchema(xmlFragment, schemaStatement, removeContainer);
        log.debug((Object)("Valiating " + xml));
        String errors = XSDValidator.validate(xml, XSDValidator.class.getResourceAsStream(schemaResource));
        if (!"".equals(errors)) {
            log.error((Object)("Failed to validate " + xml));
        }
        if (!"".equals(errors)) {
            throw new Error("XML document does not validate \n" + errors + "\n" + xml);
        }
        return xml;
    }
}

