/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.config;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.shindig.auth.AuthenticationHandler;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.PropertiesModule;
import org.apache.shindig.social.core.config.SocialApiGuiceModule;
import org.apache.shindig.social.core.oauth.AuthenticationHandlerProvider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SocialApiGuiceModuleTest
extends TestCase {
    private Injector injector;

    public void setUp() throws Exception {
        super.setUp();
        System.out.println("plop");
        this.injector = Guice.createInjector((Module[])new Module[]{new ConfigModule(), new SocialApiGuiceModule(), new PropertiesModule()});
    }

    public void testAuthHandler() {
        ((AuthenticationHandlerProvider)this.injector.getInstance(AuthenticationHandlerProvider.class)).get();
        AuthenticationHandlerProvider provider = (AuthenticationHandlerProvider)this.injector.getInstance(AuthenticationHandlerProvider.class);
        SocialApiGuiceModuleTest.assertEquals((int)3, (int)provider.get().size());
        List handlers = (List)this.injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<List<AuthenticationHandler>>(){}));
        SocialApiGuiceModuleTest.assertEquals((int)3, (int)handlers.size());
    }

    public class ConfigModule
    extends AbstractModule {
        protected void configure() {
            this.bind(ContainerConfig.class).to(FakeContainerConfig.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FakeContainerConfig
    implements ContainerConfig {
        private final Map<String, String> properties = Maps.newHashMap();

        protected FakeContainerConfig() {
        }

        public String get(String container, String property) {
            if (property.equals("gadgets.securityTokenType")) {
                return "insecure";
            }
            return this.properties.get(property);
        }

        public Collection<String> getContainers() {
            return null;
        }

        public Object getJson(String container, String parameter) {
            return null;
        }

        public JSONArray getJsonArray(String container, String parameter) {
            return null;
        }

        public JSONObject getJsonObject(String container, String parameter) {
            if (parameter.equals("gadgets.content-rewrite")) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    JSONArray tags = new JSONArray();
                    tags.put((Object)"embed");
                    tags.put((Object)"img");
                    tags.put((Object)"script");
                    tags.put((Object)"link");
                    tags.put((Object)"style");
                    jsonObject.put("include-tags", (Object)tags);
                    jsonObject.put("include-urls", (Object)".*");
                    jsonObject.put("exclude-urls", (Object)"");
                    jsonObject.put("expires", (Object)"HTTP");
                    jsonObject.put("proxy-url", (Object)"http://www.test.com/dir/proxy?url=");
                    jsonObject.put("concat-url", (Object)"http://www.test.com/dir/concat?");
                    return jsonObject;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

