/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import junit.framework.TestCase;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.social.core.model.ActivityImpl;
import org.apache.shindig.social.core.model.AddressImpl;
import org.apache.shindig.social.core.model.ListFieldImpl;
import org.apache.shindig.social.core.model.MediaItemImpl;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.core.util.BeanXmlConverter;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.Address;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Name;
import org.apache.shindig.social.opensocial.model.Person;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeanXmlConverterTest
extends TestCase {
    private Person johnDoe;
    private Activity activity;
    private BeanXmlConverter beanXmlConverter;

    public void setUp() throws Exception {
        super.setUp();
        this.johnDoe = new PersonImpl("johnDoeId", "Johnny", (Name)new NameImpl("John Doe"));
        this.johnDoe.setPhoneNumbers((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("home", "+33H000000000"), new ListFieldImpl("mobile", "+33M000000000"), new ListFieldImpl("work", "+33W000000000")}));
        this.johnDoe.setAddresses((List)Lists.newArrayList((Object[])new Address[]{new AddressImpl("My home address")}));
        this.johnDoe.setEmails((List)Lists.newArrayList((Object[])new ListField[]{new ListFieldImpl("work", "john.doe@work.bar"), new ListFieldImpl("home", "john.doe@home.bar")}));
        this.activity = new ActivityImpl("activityId", this.johnDoe.getId());
        this.activity.setMediaItems((List)Lists.newArrayList((Object[])new MediaItem[]{new MediaItemImpl("image/jpg", MediaItem.Type.IMAGE, "http://foo.bar")}));
        this.beanXmlConverter = new BeanXmlConverter();
    }

    public void testToXmlOnSimpleClass() throws Exception {
        SimplePerson cassie = new SimplePerson("5", "robot");
        String xml = this.beanXmlConverter.convertToXml((Object)cassie);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        Node name = element.getElementsByTagName("name").item(0);
        BeanXmlConverterTest.assertEquals((String)"5", (String)id.getTextContent());
        BeanXmlConverterTest.assertEquals((String)"robot", (String)name.getTextContent());
    }

    public void testPersonToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToXml((Object)this.johnDoe);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXmlConverterTest.assertEquals((String)this.johnDoe.getId(), (String)id.getTextContent());
    }

    public void testActivityToXml() throws Exception {
        String xml = this.beanXmlConverter.convertToXml((Object)this.activity);
        Element element = XmlUtil.parse((String)xml);
        Node id = element.getElementsByTagName("id").item(0);
        BeanXmlConverterTest.assertEquals((String)this.activity.getId(), (String)id.getTextContent());
    }

    public void xxxtestMapsToXml() throws Exception {
        TreeMap<String, HashMap> map = new TreeMap<String, HashMap>();
        HashMap item1Map = Maps.newHashMap();
        item1Map.put("value", "1");
        map.put("item1", item1Map);
        HashMap item2Map = Maps.newHashMap();
        item2Map.put("value", "2");
        map.put("item2", item2Map);
        String xml = this.beanXmlConverter.convertToXml(map);
        XmlUtil.parse((String)xml);
        String expectedXml = "<treemap><empty>false</empty><entry><key>item1</key><value><empty>false</empty><entry><key>value</key><value>1</value></entry></value></entry><entry><key>item2</key><value><empty>false</empty><entry><key>value</key><value>2</value></entry></value></entry></treemap>";
        BeanXmlConverterTest.assertEquals((String)expectedXml, (String)StringUtils.deleteWhitespace((String)xml));
    }

    public static class SimplePerson {
        private String id;
        private String name;

        public SimplePerson(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

