/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth2;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.shindig.social.core.oauth2.OAuth2Client;
import org.apache.shindig.social.core.oauth2.OAuth2Code;
import org.apache.shindig.social.core.oauth2.OAuth2DataService;
import org.apache.shindig.social.core.oauth2.OAuth2Exception;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedRequest;
import org.apache.shindig.social.core.oauth2.OAuth2NormalizedResponse;
import org.apache.shindig.social.core.oauth2.OAuth2Service;
import org.apache.shindig.social.core.oauth2.OAuth2Types;
import org.apache.shindig.social.core.oauth2.validators.AccessTokenRequestValidator;
import org.apache.shindig.social.core.oauth2.validators.AuthorizationCodeRequestValidator;
import org.apache.shindig.social.core.oauth2.validators.DefaultResourceRequestValidator;
import org.apache.shindig.social.core.oauth2.validators.OAuth2ProtectedResourceValidator;
import org.apache.shindig.social.core.oauth2.validators.OAuth2RequestValidator;

@Singleton
public class OAuth2ServiceImpl
implements OAuth2Service {
    private OAuth2DataService store;
    private long authCodeExpires;
    private long accessTokenExpires;
    private OAuth2RequestValidator accessTokenValidator;
    private OAuth2RequestValidator authCodeValidator;
    private OAuth2ProtectedResourceValidator resourceReqValidator;

    @Inject
    public OAuth2ServiceImpl(OAuth2DataService store, @Named(value="shindig.oauth2.authCodeExpiration") long authCodeExpires, @Named(value="shindig.oauth2.accessTokenExpiration") long accessTokenExpires) {
        this.store = store;
        this.authCodeExpires = authCodeExpires;
        this.accessTokenExpires = accessTokenExpires;
        this.authCodeValidator = new AuthorizationCodeRequestValidator(store);
        this.accessTokenValidator = new AccessTokenRequestValidator(store);
        this.resourceReqValidator = new DefaultResourceRequestValidator(store);
    }

    @Override
    public OAuth2DataService getDataService() {
        return this.store;
    }

    protected long getAuthCodeExpires() {
        return this.authCodeExpires;
    }

    protected long getAccessTokenExpires() {
        return this.accessTokenExpires;
    }

    @Override
    public void authenticateClient(OAuth2NormalizedRequest req) throws OAuth2Exception {
        OAuth2Client client = this.store.getClient(req.getClientId());
        if (client == null) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.INVALID_CLIENT.toString());
            resp.setErrorDescription("The client ID is invalid or not registered");
            resp.setBodyReturned(true);
            resp.setStatus(400);
            throw new OAuth2Exception(resp);
        }
        String realSecret = client.getSecret();
        String reqSecret = req.getClientSecret();
        if (!(realSecret == null && reqSecret == null && client.getType() != OAuth2Client.ClientType.CONFIDENTIAL || realSecret != null && reqSecret != null && realSecret.equals(reqSecret))) {
            OAuth2NormalizedResponse resp = new OAuth2NormalizedResponse();
            resp.setError(OAuth2Types.ErrorType.UNAUTHORIZED_CLIENT.toString());
            resp.setErrorDescription("The client failed to authorize");
            resp.setBodyReturned(true);
            resp.setStatus(400);
            throw new OAuth2Exception(resp);
        }
    }

    @Override
    public void validateRequestForAuthCode(OAuth2NormalizedRequest req) throws OAuth2Exception {
        this.authCodeValidator.validateRequest(req);
    }

    @Override
    public void validateRequestForAccessToken(OAuth2NormalizedRequest req) throws OAuth2Exception {
        this.accessTokenValidator.validateRequest(req);
    }

    @Override
    public void validateRequestForResource(OAuth2NormalizedRequest req, Object resourceRequest) throws OAuth2Exception {
        this.resourceReqValidator.validateRequestForResource(req, resourceRequest);
    }

    @Override
    public OAuth2Code grantAuthorizationCode(OAuth2NormalizedRequest req) {
        OAuth2Code authCode = this.generateAuthorizationCode(req);
        this.store.registerAuthorizationCode(req.getClientId(), authCode);
        return authCode;
    }

    @Override
    public OAuth2Code grantAccessToken(OAuth2NormalizedRequest req) {
        OAuth2Code accessToken = this.generateAccessToken(req);
        OAuth2Code authCode = this.store.getAuthorizationCode(req.getClientId(), req.getAuthorizationCode());
        if (authCode != null) {
            authCode.setRelatedAccessToken(accessToken);
        }
        this.store.registerAccessToken(req.getClientId(), accessToken);
        return accessToken;
    }

    @Override
    public OAuth2Code grantRefreshToken(OAuth2NormalizedRequest req) {
        OAuth2Code refreshToken = this.generateRefreshToken(req);
        this.store.registerRefreshToken(req.getClientId(), refreshToken);
        return refreshToken;
    }

    @Override
    public OAuth2Code generateAuthorizationCode(OAuth2NormalizedRequest req) {
        OAuth2Code authCode = new OAuth2Code();
        authCode.setValue(UUID.randomUUID().toString());
        authCode.setExpiration(System.currentTimeMillis() + this.authCodeExpires);
        OAuth2Client client = this.store.getClient(req.getClientId());
        authCode.setClient(client);
        if (req.getRedirectURI() != null) {
            authCode.setRedirectURI(req.getRedirectURI());
        } else {
            authCode.setRedirectURI(client.getRedirectURI());
        }
        return authCode;
    }

    @Override
    public OAuth2Code generateAccessToken(OAuth2NormalizedRequest req) {
        OAuth2Code accessToken = new OAuth2Code();
        accessToken.setType(OAuth2Types.CodeType.ACCESS_TOKEN);
        accessToken.setValue(UUID.randomUUID().toString());
        accessToken.setExpiration(System.currentTimeMillis() + this.accessTokenExpires);
        if (req.getRedirectURI() != null) {
            accessToken.setRedirectURI(req.getRedirectURI());
        } else {
            accessToken.setRedirectURI(this.store.getClient(req.getClientId()).getRedirectURI());
        }
        if (req.getAuthorizationCode() != null) {
            OAuth2Code authCode = this.store.getAuthorizationCode(req.getClientId(), req.getAuthorizationCode());
            accessToken.setRelatedAuthCode(authCode);
            accessToken.setClient(authCode.getClient());
            if (authCode.getScope() != null) {
                accessToken.setScope(new ArrayList<String>(authCode.getScope()));
            }
        }
        return accessToken;
    }

    @Override
    public OAuth2Code generateRefreshToken(OAuth2NormalizedRequest req) {
        throw new RuntimeException("not yet implemented");
    }
}

