/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.oauth;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.util.CharsetUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeOAuthRequest {
    public static final String CONSUMER_KEY = "gadget:12345";
    public static final String CONSUMER_SECRET = "secret";
    public static final String REQUESTOR = "requestor12345";
    final String method;
    final String url;
    final String body;
    final String contentType;

    public FakeOAuthRequest(String method, String url, String body, String contentType) {
        this.method = method;
        this.url = url;
        this.body = body;
        this.contentType = contentType;
    }

    public FakeHttpServletRequest sign(String token, OAuthParamLocation paramLocationEnum, BodySigning bodySigning) throws Exception {
        return this.sign(CONSUMER_KEY, CONSUMER_SECRET, REQUESTOR, token, token == null ? null : CONSUMER_SECRET, paramLocationEnum, bodySigning);
    }

    public FakeHttpServletRequest sign(String consumerKey, String consumerSecret, String requestor, String token, String tokenSecret, OAuthParamLocation paramLocationEnum, BodySigning bodySigning) throws Exception {
        FakeHttpServletRequest request = new FakeHttpServletRequest(this.url);
        ArrayList oauthParams = Lists.newArrayList();
        UriBuilder target = new UriBuilder(Uri.parse((String)this.url));
        String query = target.getQuery();
        target.setQuery(null);
        oauthParams.addAll(OAuth.decodeForm((String)query));
        if (this.body != null) {
            if (OAuth.isFormEncoded((String)this.contentType)) {
                oauthParams.addAll(OAuth.decodeForm((String)this.body));
            } else if (bodySigning == BodySigning.LEGACY) {
                oauthParams.add(new OAuth.Parameter(this.body, ""));
            } else if (bodySigning == BodySigning.HASH) {
                oauthParams.add(new OAuth.Parameter("oauth_body_hash", new String(Base64.encodeBase64((byte[])DigestUtils.sha((byte[])this.body.getBytes())), "UTF-8")));
            }
        }
        oauthParams.add(new OAuth.Parameter("oauth_consumer_key", consumerKey));
        oauthParams.add(new OAuth.Parameter("xoauth_requestor_id", requestor));
        OAuthConsumer consumer = new OAuthConsumer(null, consumerKey, consumerSecret, null);
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        if (!StringUtils.isEmpty((String)token)) {
            accessor.accessToken = token;
            accessor.tokenSecret = tokenSecret;
        }
        OAuthMessage message = accessor.newRequestMessage(this.method, target.toString(), (Collection)oauthParams);
        List<Map.Entry<String, String>> entryList = FakeOAuthRequest.selectOAuthParams(message);
        switch (paramLocationEnum) {
            case AUTH_HEADER: {
                request.setHeader("Authorization", FakeOAuthRequest.getAuthorizationHeader(entryList));
                break;
            }
            case POST_BODY: {
                if (!OAuth.isFormEncoded((String)this.contentType)) {
                    throw new RuntimeException("OAuth param location can only be post_body if post body is of type x-www-form-urlencoded");
                }
                for (Map.Entry param : message.getParameters()) {
                    request.setParameter((String)param.getKey(), true, new String[]{(String)param.getValue()});
                }
                String oauthData = OAuth.formEncode((Iterable)message.getParameters());
                request.setPostData(CharsetUtil.getUtf8Bytes((String)oauthData));
                break;
            }
            case URI_QUERY: {
                request.setQueryString(Uri.parse((String)OAuth.addParameters((String)this.url, entryList)).getQuery());
            }
        }
        if (this.body != null && paramLocationEnum != OAuthParamLocation.POST_BODY) {
            request.setContentType(this.contentType);
            request.setPostData(this.body, "UTF-8");
            if (this.contentType.contains("application/x-www-form-urlencoded")) {
                List bodyParams = OAuth.decodeForm((String)this.body);
                for (OAuth.Parameter bodyParam : bodyParams) {
                    request.setParameter(bodyParam.getKey(), new String[]{bodyParam.getValue()});
                }
            }
        }
        request.setMethod(this.method);
        return request;
    }

    private static String getAuthorizationHeader(List<Map.Entry<String, String>> oauthParams) {
        StringBuilder result = new StringBuilder("OAuth ");
        boolean first = true;
        for (Map.Entry<String, String> parameter : oauthParams) {
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            result.append(OAuth.percentEncode((String)parameter.getKey())).append("=\"").append(OAuth.percentEncode((String)parameter.getValue())).append('\"');
        }
        return result.toString();
    }

    private static List<Map.Entry<String, String>> selectOAuthParams(OAuthMessage message) throws IOException {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry param : message.getParameters()) {
            if (!FakeOAuthRequest.isContainerInjectedParameter((String)param.getKey())) continue;
            result.add(param);
        }
        return result;
    }

    private static boolean isContainerInjectedParameter(String key) {
        return (key = key.toLowerCase()).startsWith("oauth") || key.startsWith("xoauth") || key.startsWith("opensocial");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OAuthParamLocation {
        AUTH_HEADER,
        POST_BODY,
        URI_QUERY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BodySigning {
        NONE,
        HASH,
        LEGACY;

    }
}

