/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.dataservice.integration;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.shindig.auth.AuthInfo;
import org.apache.shindig.common.EasyMockTestCase;
import org.apache.shindig.common.testing.FakeGadgetToken;
import org.apache.shindig.common.testing.FakeHttpServletRequest;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.protocol.DataServiceServlet;
import org.apache.shindig.protocol.HandlerRegistry;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.conversion.BeanJsonConverter;
import org.apache.shindig.protocol.conversion.BeanXStreamConverter;
import org.apache.shindig.protocol.conversion.xstream.XStreamConfiguration;
import org.apache.shindig.social.SocialApiTestsGuiceModule;
import org.apache.shindig.social.core.util.BeanXStreamAtomConverter;
import org.apache.shindig.social.core.util.xstream.XStream081Configuration;
import org.custommonkey.xmlunit.NamespaceContext;
import org.custommonkey.xmlunit.SimpleNamespaceContext;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XpathEngine;
import org.easymock.EasyMock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLargeRestfulTests
extends EasyMockTestCase {
    protected static final String XMLSCHEMA = " xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n xsi:schemaLocation=\"http://ns.opensocial.org/2008/opensocial classpath:opensocial.xsd\" ";
    protected static final String XSDRESOURCE = "opensocial.xsd";
    protected XpathEngine xp;
    private HttpServletResponse res;
    private DataServiceServlet servlet;
    private static final FakeGadgetToken FAKE_GADGET_TOKEN = new FakeGadgetToken().setOwnerId("john.doe").setViewerId("john.doe");

    protected HttpServletResponse getResponse() {
        return this.res;
    }

    protected void setResponse(HttpServletResponse res) {
        this.res = res;
    }

    protected DataServiceServlet getServlet() {
        return this.servlet;
    }

    protected void setServlet(DataServiceServlet servlet) {
        this.servlet = servlet;
    }

    protected void setUp() throws Exception {
        super.setUp();
        Injector injector = Guice.createInjector((Module[])new Module[]{new SocialApiTestsGuiceModule(), new ConfigModule()});
        this.servlet = new DataServiceServlet();
        HandlerRegistry dispatcher = (HandlerRegistry)injector.getInstance(HandlerRegistry.class);
        dispatcher.addHandlers((Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<Object>>(){}, (Annotation)Names.named((String)"org.apache.shindig.social.handlers"))));
        this.servlet.setHandlerRegistry(dispatcher);
        this.servlet.setBeanConverters((BeanConverter)new BeanJsonConverter(injector), (BeanConverter)new BeanXStreamConverter((XStreamConfiguration)new XStream081Configuration(injector)), (BeanConverter)new BeanXStreamAtomConverter((XStreamConfiguration)new XStream081Configuration(injector)));
        this.res = (HttpServletResponse)EasyMock.createMock(HttpServletResponse.class);
        SimpleNamespaceContext ns = new SimpleNamespaceContext((Map)ImmutableMap.of((Object)"", (Object)"http://ns.opensocial.org/2008/opensocial"));
        XMLUnit.setXpathNamespaceContext((NamespaceContext)ns);
        this.xp = XMLUnit.newXpathEngine();
    }

    protected String getResponse(String path, String method, String format, String contentType) throws Exception {
        return this.getResponse(path, method, Maps.newHashMap(), "", format, contentType);
    }

    protected String getResponse(String path, String method, Map<String, String> extraParams, String format, String contentType) throws Exception {
        return this.getResponse(path, method, extraParams, "", format, contentType);
    }

    protected String getResponse(String path, String method, String postData, String format, String contentType) throws Exception {
        return this.getResponse(path, method, Maps.newHashMap(), postData, format, contentType);
    }

    protected String getResponse(String path, String method, Map<String, String> extraParams, String postData, String format, String contentType) throws Exception {
        FakeHttpServletRequest req = new FakeHttpServletRequest();
        req.setCharacterEncoding("UTF-8");
        req.setPathInfo(path);
        req.setParameter("format", new String[]{format});
        req.setParameter("X-HTTP-Method-Override", new String[]{method});
        req.setAttribute(AuthInfo.Attribute.SECURITY_TOKEN.getId(), (Object)FAKE_GADGET_TOKEN);
        req.setContentType(contentType);
        for (Map.Entry<String, String> entry : extraParams.entrySet()) {
            req.setParameter(entry.getKey(), new String[]{entry.getValue()});
        }
        if (!"GET".equals(method) && !"HEAD".equals(method)) {
            if (postData == null) {
                postData = "";
            }
            req.setPostData(postData.getBytes());
        }
        req.setMethod(method);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(outputStream);
        EasyMock.expect((Object)this.res.getWriter()).andReturn((Object)writer);
        this.res.setCharacterEncoding("UTF-8");
        this.res.setContentType(contentType);
        EasyMock.replay((Object[])new Object[]{this.res});
        this.servlet.service((ServletRequest)req, (ServletResponse)this.res);
        EasyMock.verify((Object[])new Object[]{this.res});
        EasyMock.reset((Object[])new Object[]{this.res});
        writer.flush();
        return outputStream.toString();
    }

    protected JSONObject getJson(String json) throws Exception {
        return new JSONObject(json);
    }

    protected Map<String, String> parseXmlContent(String str) throws XMLStreamException {
        ByteArrayInputStream inStr = new ByteArrayInputStream(str.getBytes());
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLStreamReader parser = factory.createXMLStreamReader(inStr);
        HashMap columns = Maps.newHashMap();
        while (true) {
            int event;
            if ((event = parser.next()) == 8) break;
            if (event != 1) continue;
            String name = parser.getLocalName();
            int eventType = parser.next();
            if (eventType != 4) continue;
            String value = parser.getText();
            columns.put(name, value);
        }
        parser.close();
        return columns;
    }

    protected Map<String, List<String>> childNodesToMap(Node n) {
        HashMap v = Maps.newHashMap();
        NodeList result = n.getChildNodes();
        for (int i = 0; i < result.getLength(); ++i) {
            Node nv = result.item(i);
            if (nv.getNodeType() != 1) continue;
            List l = (List)v.get(nv.getLocalName());
            if (l == null) {
                l = Lists.newArrayList();
                v.put(nv.getLocalName(), l);
            }
            l.add(nv.getTextContent());
        }
        return v;
    }

    protected Map<String, Map<String, List<String>>> childNodesToMapofMap(NodeList result) {
        HashMap v = Maps.newHashMap();
        for (int i = 0; i < result.getLength(); ++i) {
            Map<String, List<Node>> keyValue = this.childNodesToNodeMap(result.item(i));
            AbstractLargeRestfulTests.assertEquals((int)2, (int)keyValue.size());
            AbstractLargeRestfulTests.assertTrue((boolean)keyValue.containsKey("key"));
            AbstractLargeRestfulTests.assertTrue((boolean)keyValue.containsKey("value"));
            Node valueNode = keyValue.get("value").get(0);
            Node key = keyValue.get("key").get(0);
            NodeList entryList = valueNode.getChildNodes();
            HashMap pv = Maps.newHashMap();
            v.put(key.getTextContent(), pv);
            for (int j = 0; j < entryList.getLength(); ++j) {
                Node n = entryList.item(j);
                if (!"entry".equals(n.getNodeName())) continue;
                Map<String, List<String>> ve = this.childNodesToMap(entryList.item(j));
                AbstractLargeRestfulTests.assertTrue((boolean)ve.containsKey("key"));
                List l = (List)pv.get(ve.get("key").get(0));
                if (l == null) {
                    l = Lists.newArrayList();
                    pv.put(ve.get("key").get(0), l);
                }
                l.add(ve.get("value").get(0));
            }
        }
        return v;
    }

    protected Map<String, List<Node>> childNodesToNodeMap(Node n) {
        HashMap v = Maps.newHashMap();
        NodeList result = n.getChildNodes();
        for (int i = 0; i < result.getLength(); ++i) {
            Node nv = result.item(i);
            if (nv.getNodeType() != 1) continue;
            List l = (List)v.get(nv.getLocalName());
            if (l == null) {
                l = Lists.newArrayList();
                v.put(nv.getLocalName(), l);
            }
            l.add(nv);
        }
        return v;
    }

    public class ConfigModule
    extends AbstractModule {
        protected void configure() {
            this.bind(ContainerConfig.class).to(FakeContainerConfig.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class FakeContainerConfig
    implements ContainerConfig {
        private final Map<String, String> properties = Maps.newHashMap();

        protected FakeContainerConfig() {
        }

        public boolean getBool(String container, String name) {
            return false;
        }

        public Collection<String> getContainers() {
            return null;
        }

        public int getInt(String container, String name) {
            return 0;
        }

        public List<Object> getList(String container, String name) {
            return null;
        }

        public Map<String, Object> getMap(String container, String name) {
            return null;
        }

        public Map<String, Object> getProperties(String container) {
            return null;
        }

        public Object getProperty(String container, String name) {
            if (name.equals("gadgets.content-rewrite")) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    JSONArray tags = new JSONArray();
                    tags.put((Object)"embed");
                    tags.put((Object)"img");
                    tags.put((Object)"script");
                    tags.put((Object)"link");
                    tags.put((Object)"style");
                    jsonObject.put("include-tags", (Object)tags);
                    jsonObject.put("include-urls", (Object)".*");
                    jsonObject.put("exclude-urls", (Object)"");
                    jsonObject.put("expires", (Object)"HTTP");
                    jsonObject.put("proxy-url", (Object)"http://www.test.com/dir/proxy?url=");
                    jsonObject.put("concat-url", (Object)"http://www.test.com/dir/concat?");
                    return jsonObject;
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
            return null;
        }

        public String getString(String container, String name) {
            return this.properties.get(name);
        }
    }
}

