/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.model;

import junit.framework.TestCase;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.ListField;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.model.Url;

public class PersonTest
extends TestCase {
    public void testInvalidFromUrlString() throws Exception {
        PersonTest.assertNull((Object)Person.Field.fromUrlString((String)"badness"));
    }

    public void testFromUrlString() throws Exception {
        this.assertUrlStringMaps(Person.Field.NAME);
        this.assertUrlStringMaps(Person.Field.THUMBNAIL_URL);
    }

    private void assertUrlStringMaps(Person.Field field) {
        PersonTest.assertEquals((Object)field, (Object)Person.Field.fromUrlString((String)field.toString()));
    }

    public void testGetProfileUrl() throws Exception {
        PersonImpl person = new PersonImpl();
        PersonTest.assertNull((Object)person.getProfileUrl());
        String address = "hi";
        person.setProfileUrl(address);
        PersonTest.assertEquals((String)address, (String)person.getProfileUrl());
        PersonTest.assertEquals((String)address, (String)((Url)person.getUrls().get(0)).getValue());
        PersonTest.assertEquals((String)"profile", (String)((Url)person.getUrls().get(0)).getType());
        PersonTest.assertNull((Object)((Url)person.getUrls().get(0)).getLinkText());
        address = "something new";
        person.setProfileUrl(address);
        PersonTest.assertEquals((String)address, (String)person.getProfileUrl());
        PersonTest.assertEquals((int)1, (int)person.getUrls().size());
        PersonTest.assertEquals((String)address, (String)((Url)person.getUrls().get(0)).getValue());
    }

    public void testGetThumbnailUrl() throws Exception {
        PersonImpl person = new PersonImpl();
        PersonTest.assertNull((Object)person.getThumbnailUrl());
        String url = "hi";
        person.setThumbnailUrl(url);
        PersonTest.assertEquals((String)url, (String)person.getThumbnailUrl());
        PersonTest.assertEquals((String)url, (String)((ListField)person.getPhotos().get(0)).getValue());
        PersonTest.assertEquals((String)"thumbnail", (String)((ListField)person.getPhotos().get(0)).getType());
        url = "something new";
        person.setThumbnailUrl(url);
        PersonTest.assertEquals((String)url, (String)person.getThumbnailUrl());
        PersonTest.assertEquals((int)1, (int)person.getPhotos().size());
        PersonTest.assertEquals((String)url, (String)((ListField)person.getPhotos().get(0)).getValue());
    }
}

