/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.core.util;

import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class JsonLibConverterUtils {
    protected static final Log LOG = LogFactory.getLog(JsonLibConverterUtils.class);

    public static final void dumpJsonObject(JSONObject jsonObject, String indent) {
        for (Object o : jsonObject.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof JSONObject) {
                LOG.info((Object)(indent + key + ":JSONObject"));
                JsonLibConverterUtils.dumpJsonObject((JSONObject)value, indent + "  ");
                continue;
            }
            if (value instanceof JSONArray) {
                LOG.info((Object)(indent + key + ":JSONArray " + ((JSONArray)value).size()));
                JsonLibConverterUtils.dumpJsonArray((JSONArray)value, indent + "  ");
                continue;
            }
            if (value == null) {
                LOG.info((Object)(indent + key + ":null:na"));
                continue;
            }
            LOG.info((Object)(indent + key + ":" + value + ":" + value.getClass()));
        }
    }

    public static void dumpJsonArray(JSONArray array, String indent) {
        for (Object value : array) {
            if (value instanceof JSONObject) {
                LOG.info((Object)(indent + ":JSONObject"));
                JsonLibConverterUtils.dumpJsonObject((JSONObject)value, indent + "  ");
                continue;
            }
            if (value instanceof JSONArray) {
                LOG.info((Object)(indent + ":JSONArray " + ((JSONArray)value).size()));
                JsonLibConverterUtils.dumpJsonArray((JSONArray)value, indent + "  ");
                continue;
            }
            LOG.info((Object)(indent + ":" + value + ":" + (value == null ? "na" : value.getClass())));
        }
    }
}

