/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.opensocial.service;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Map;
import org.apache.shindig.social.opensocial.service.ActivityHandler;
import org.apache.shindig.social.opensocial.service.AppDataHandler;
import org.apache.shindig.social.opensocial.service.DataRequestHandler;
import org.apache.shindig.social.opensocial.service.HandlerDispatcher;
import org.apache.shindig.social.opensocial.service.PersonHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardHandlerDispatcher
implements HandlerDispatcher {
    private final Map<String, Provider<? extends DataRequestHandler>> handlers;

    @Inject
    public StandardHandlerDispatcher(Provider<PersonHandler> personHandlerProvider, Provider<ActivityHandler> activityHandlerProvider, Provider<AppDataHandler> appDataHandlerProvider) {
        this(Maps.immutableMap((Object)"people", personHandlerProvider, (Object)"activities", activityHandlerProvider, (Object)"appdata", appDataHandlerProvider));
    }

    public StandardHandlerDispatcher(Map<String, Provider<? extends DataRequestHandler>> handlers) {
        this.handlers = Maps.newHashMap(handlers);
    }

    @Override
    public DataRequestHandler getHandler(String service) {
        Provider<? extends DataRequestHandler> provider = this.handlers.get(service);
        if (provider == null) {
            return null;
        }
        return (DataRequestHandler)provider.get();
    }

    public void addHandler(String service, Provider<? extends DataRequestHandler> handler) {
        this.handlers.put(service, handler);
    }
}

