/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.gauges.jvm;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.apache.sirona.Role;
import org.apache.sirona.counters.Unit;
import org.apache.sirona.gauges.Gauge;

public class CPUGauge
implements Gauge {
    public static final Role CPU = new Role("CPU", Unit.UNARY);
    private static final OperatingSystemMXBean SYSTEM_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private Method method;

    public CPUGauge() {
        try {
            this.method = OperatingSystemMXBean.class.getMethod("getSystemLoadAverage", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public Role role() {
        return CPU;
    }

    public double value() {
        if (this.method == null) {
            return -1.0;
        }
        try {
            return (Double)this.method.invoke((Object)SYSTEM_MX_BEAN, null);
        }
        catch (Exception e) {
            return -1.0;
        }
    }
}

