/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sirona.store.tracking;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sirona.configuration.Configuration;
import org.apache.sirona.configuration.ioc.Created;
import org.apache.sirona.store.BatchFuture;
import org.apache.sirona.store.memory.tracking.InMemoryPathTrackingDataStore;
import org.apache.sirona.util.DaemonThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BatchPathTrackingDataStore
extends InMemoryPathTrackingDataStore {
    private static final Logger LOGGER = Logger.getLogger(BatchPathTrackingDataStore.class.getName());
    protected BatchFuture scheduledTask;

    @Created
    public void initBatch() {
        String name = ((Object)((Object)this)).getClass().getSimpleName().toLowerCase(Locale.ENGLISH).replace("pathtrackingdatastore", "");
        long period = this.getPeriod(name);
        ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DaemonThreadFactory(name + "-pathtracking-schedule-"));
        ScheduledFuture<?> future = ses.scheduleAtFixedRate(new PushPathTrackingTask(), period, period, TimeUnit.MILLISECONDS);
        this.scheduledTask = new BatchFuture(ses, future);
    }

    protected int getPeriod(String name) {
        int period = Configuration.getInteger((String)("org.apache.sirona." + name + ".pathtracking.period"), (int)Configuration.getInteger((String)("org.apache.sirona." + name + ".period"), (int)60000));
        return period;
    }

    protected abstract void pushEntriesByBatch(Map<String, List<InMemoryPathTrackingDataStore.Pointer>> var1);

    private class PushPathTrackingTask
    implements Runnable {
        private PushPathTrackingTask() {
        }

        public void run() {
            try {
                BatchPathTrackingDataStore.this.pushEntriesByBatch(BatchPathTrackingDataStore.this.getPointers());
                BatchPathTrackingDataStore.this.clearEntries();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
        }
    }
}

